(function(ng, $){
    'use strict';

    ng.module('farbtastic', [])
        .directive('ngFarbtastic',
        function($rootScope) {
            return {
                restrict: 'EA',
                require: '^ngModel',
                link: function($scope, $element, $attrs, ngModel) {
                    var fContainer = ng.element("#colorpicker"),
                        farbtastic = $.farbtastic(fContainer);

                    fContainer.hide();

                    function blackValue(hex) {
                        if (!hex) return 0;
                        hex = hex.replace("#", "").replace(/[^0-9A-F]/gi, '');
                        var bigint = parseInt(hex, 16);
                        var r = (bigint >> 16) & 255;
                        var g = (bigint >> 8) & 255;
                        var b = bigint & 255;
                        return ((r * 0.299) + (g * 0.587) + (b * 0.114));
                    }

                    $scope.$watch(function(){return ngModel.$viewValue}, function() {
                        if (!ngModel.$viewValue) return;
                        farbtastic.setColor(ngModel.$viewValue);
                        $element.css({
                            backgroundColor: ngModel.$viewValue,
                            color: blackValue(ngModel.$viewValue) < 128 ? "#ffffff" : "#000000"
                        });
                    });

                    $element.on("click", function(){
                        farbtastic.linkTo(function(color){
                            $element.val(color);
                            ngModel.$setViewValue(color);
                        });
                        farbtastic.setColor(ngModel.$viewValue);
                        var offset = $element.offset();

                        var farbastic = {
                            top: offset.top - 90,
                            left: offset.left + $element.width(),
                            height: 195
                        }

                        if(ng.element("body").height() < farbastic.top + farbastic.height) {
                            farbastic.top -= farbastic.top + farbastic.height - ng.element("body").height();
                        }

                        fContainer.css({
                            top: farbastic.top,
                            left: farbastic.left,
                            position: "absolute",
                            zIndex: 100
                        });
                        fContainer.show();
                        $rootScope.$broadcast("farbastic:open", {modelName: $attrs.ngModel});
                        ng.element("body").on("keydown", closePicker)
                    });
                    $element.on("blur", function(){
                        fContainer.hide();
                        $rootScope.$broadcast("farbastic:close", {modelName: $attrs.ngModel});
                        ng.element("body").off("keydown", closePicker)
                    });

                    function closePicker(e) {
                        if(fContainer.css("display") !== "none" && e.keyCode === 27){
                            fContainer.hide();
                            $rootScope.$broadcast("farbastic:close", {modelName: $attrs.ngModel});
                            ng.element("body").off("keydown", closePicker)
                        }
                    }
                }
            };
        })
})(angular, jQuery);
