(function (ng, $) {
    'use strict';
    var app = ng.module("ufApp.services.formService", ['ngFileUpload']);
    app.factory("formService", ["$rootScope", "$window", "$http", "$log", "$q", "Upload", function ($rootScope, $window, $http, $log, $q, Upload) {
        return {
            _request: function (params) {
                return $q(function (resolve, reject) {
                    var request = $http({
                        method: 'POST',
                        url: $window.g_urlAjaxActions,
                        data: $.param(params),
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'}
                    });
                    request.success(function (response) {
                        var responsePayload = typeof response === "object" ? (response.data ? ng.fromJson(response.data) : response.message) : response;
                        if (response.success) {
                            resolve(responsePayload);
                        } else {
                            reject(responsePayload);
                            $rootScope.$broadcast("add alert", {
                                type: "danger",
                                msg: responsePayload
                            });
                        }
                    });
                });
            },
            get: function (formId) {
                var params = {
                    client_action: "get_settings",
                    data: {
                        formID: formId
                    }
                };
                return this._request(params);
            },
            getStyles: function(formId){
                var params = {
                    client_action: "get_styles",
                    data: {
                        formID: formId
                    }
                };
                return this._request(params);
            },
            create: function () {
                var params = {
                    client_action: "add_form"
                };
                return this._request(params);
            },
            copy: function (formId) {
                var params = {
                    client_action: "duplicate_form",
                    data: {
                        formID: formId
                    }
                };
                return this._request(params);
            },
            list: function () {
                var params = {
                    client_action: "list_forms"
                };
                return this._request(params);
            },
            'delete': function (formId) {
                var params = {
                    client_action: "delete_form",
                    data: {
                        formID: formId
                    }
                };
                return this._request(params)
            },
            save: function (formId, styles, fields, settings) {
                var params = {
                    client_action: "save_visual",
                    data: {
                        formID: formId,
                        styles: styles,
                        fields: fields,
                        settings: settings
                    }
                };
                return this._request(params)
            },
            saveOptions: function (formId, formOptions) {
                var params = {
                    client_action: "save_form_options",
                    data: {
                        formID: formId,
                        options: formOptions
                    }
                };
                return this._request(params)
            },
            saveTitle: function (formId, title) {
                var params = {
                    client_action: "save_form_title",
                    data: {
                        formID: formId,
                        title: title
                    }
                };
                return this._request(params)
            },
            saveTemplate: function (form, styles) {
                var params = {
                    client_action: "create_template",
                    data: {
                        name: form.name,
                        alias: form.alias,
                        styles: styles,
                        type: "style"
                    }
                };
                return this._request(params);
            },
            export: function (formId) {
                $window.location = $window.g_urlAjaxActions + "&client_action=export_form&formID=" + formId;
            },
            import: function (formId, file) {
            	
            	return $q(function(resolve, reject){
                    Upload.upload({
                        url: $window.g_urlAjaxActions,
                        data: {
                            client_action: "import_form",
                            data: {
                                file: file,
                                formID: formId
                            }
                        }
                    }).then(function(response){
                        response = response.data;
                        var responsePayload = typeof response === "object" ? (response.data ? ng.fromJson(response.data) : response.message) : response;
                        if (response.success) {
                            resolve(responsePayload);
                        } else {
                            reject(responsePayload);
                            $rootScope.$broadcast("add alert", {
                                type: "danger",
                                msg: responsePayload
                            });
                        }
                    })
                });
            }
        }
    }]);

    app.service("formSettings", function ($window) {
        var formSettings = {};
        $window.formOptions.forEach(function (option) {
            formSettings[option.name] = option.value;
        });
        return formSettings;
    })
})(angular, jQuery);
