(function (ng) {
    'use strict';

    var app = ng.module("ufApp.controllers.formMainCtrl", []);
    app.controller("formMainCtrl", ["$scope", "$window", "formSettings", "formService", function ($scope, $window, formSettings, formService) {
        var self = this;
        self.alerts = [];
        self.form = $window.form;

        self.closeAlert = function (index) {
            self.alerts.splice(index, 1);
        };

        $scope.$on("add alert", function (e, alert) {
            self.alerts = [];
            self.alerts.push(alert);
        });

        $scope.$on("clear alerts", function () {
            self.alerts = [];
        });

        $scope.$on("settings:requiredFields", function (e, fields) {
            self.emptyRequiredFields = fields;
        });

        self.saveForm = function () {
            $scope.$broadcast("settings:saveSettings");
        };

        self.saveTemplate = function () {
            $scope.$broadcast("visual:saveTemplate");
        }

        self.saveTitle = function () {
            if (self.formTitleForm.$dirty) {
                formSettings.form_title = self.formTitle;
                formService.saveTitle(self.form.id, self.formTitle).then(function (response) {
                    self.alerts.push({
                        type: "success",
                        msg: response
                    });
                });
                self.formTitleForm.$setPristine();
            }
        };

        $scope.$watch(function () {
            return formSettings.form_title
        }, function (title) {
            if (title) {
                self.formTitle = formSettings.form_title;
            }
        });
    }]);
})(angular);