(function(ng){
    'use strict';

    var app = ng.module("ufApp.controllers.formNavigationCtrl", []);
    app.controller("formNavigationCtrl", ["$window", "$location", "$rootScope", "ufFormActionsUrls", function($window, $location, $rootScope, ufFormActionsUrls){
        var self = this;
        var visualFormUrl = ufFormActionsUrls.visualView + "&id=";
        self.tabs = [
            {
                title: "Add Elements",
                id: "addElements",
                url: visualFormUrl + $window.form.id + "#/addElements"
            },{
                title: "Form Style",
                id: "formStyle",
                url: visualFormUrl + $window.form.id + "#/formStyle"
            },{
                title: "Settings",
                id: "settings",
                url: visualFormUrl + $window.form.id + "#/settings"
            },
            {
                title: "Preview",
                id: "preview",
                url: ufFormActionsUrls.previewView + "&id=" + $window.form.id + "#/preview",
                broadcast: true,
                availableInDemo: false
            }
        ];
        self.isAvailableInDemo = function(tab){
            return !($window.form.isDemoMode && (typeof tab.availableInDemo !== "undefined" && tab.availableInDemo === false));
        }
        self.setActive = function(tab) {
            self.tabs.forEach(function(t){
                t.active = false
            });
            tab.active = true;
            $rootScope.activeTab = tab;
        }

        self.go = function (tab) {
            if (tab.broadcast) {
                var continued = $rootScope.$on("navigation continue", function(e, url){
                    continued();
                    $window.location.href = url;
                });
            } else {
                $window.location.href = tab.url;
            }
            $rootScope.$broadcast("navigation start", tab);
        }

        $rootScope.$on("$locationChangeSuccess", function(e, nurl, ourl){
            self.setActive(self.tabs.filter(function(t){
                return $location.path().indexOf("/" + t.id) > -1
            })[0] || self.tabs[0]);
        });

    }])
})(angular);