(function (ng, $) {
    var app = ng.module("ufApp.controllers.formSettingsCtrl", [
        'ui.tree'
    ]);
    app.filter('slice', function () {
        return function (arr, start, end) {
            return arr.slice(start, end);
        };
    });
    app.controller("formSettingsCtrl", ['$scope', '$window', '$location', '$uibModal', '$timeout', '$q', 'formService', "formSettings",
        "ufImageBrowserService", "ufElementsDefaultValues", "ufFormActionsUrls",
        function ($scope, $window, $location, $uibModal, $timeout, $q, formService, formSettings,
                  ufImageBrowserService, ufElementsDefaultValues, ufFormActionsUrls) {
            var self = this,
                _cachedFormElements = [],
                _cachedFormStyles = {},
                _cachedFormSetting = ng.copy(formSettings);
            var fieldsForLock = {
                "formPadding": [
                    "fs.activeFormStyles.formPaddingTop",
                    "fs.activeFormStyles.formPaddingRight",
                    "fs.activeFormStyles.formPaddingBottom",
                    "fs.activeFormStyles.formPaddingLeft"
                ],
                "fieldPadding": [
                    "fs.activeFormStyles.fieldPaddingTop",
                    "fs.activeFormStyles.fieldPaddingRight",
                    "fs.activeFormStyles.fieldPaddingBottom",
                    "fs.activeFormStyles.fieldPaddingLeft"
                ],
                "titlePadding": [
                    "fs.activeFormStyles.titlePaddingTop",
                    "fs.activeFormStyles.titlePaddingRight",
                    "fs.activeFormStyles.titlePaddingBottom",
                    "fs.activeFormStyles.titlePaddingLeft"
                ],
                "titleMargin": [
                    "fs.activeFormStyles.titleMarginTop",
                    "fs.activeFormStyles.titleMarginRight",
                    "fs.activeFormStyles.titleMarginBottom",
                    "fs.activeFormStyles.titleMarginLeft"
                ],
                "descriptionPadding": [
                    "fs.activeFormStyles.descriptionPaddingTop",
                    "fs.activeFormStyles.descriptionPaddingRight",
                    "fs.activeFormStyles.descriptionPaddingBottom",
                    "fs.activeFormStyles.descriptionPaddingLeft"
                ],
                "descriptionMargin": [
                    "fs.activeFormStyles.descriptionMarginTop",
                    "fs.activeFormStyles.descriptionMarginRight",
                    "fs.activeFormStyles.descriptionMarginBottom",
                    "fs.activeFormStyles.descriptionMarginLeft"
                ],
                "elementPadding": [
                    "fs.activeElement.paddingTop",
                    "fs.activeElement.paddingRight",
                    "fs.activeElement.paddingBottom",
                    "fs.activeElement.paddingLeft"
                ],
                "elementMargin": [
                    "fs.activeElement.marginTop",
                    "fs.activeElement.marginRight",
                    "fs.activeElement.marginBottom",
                    "fs.activeElement.marginLeft"
                ],
                "buttonPadding": [
                    "fs.activeFormStyles.buttonPaddingTop",
                    "fs.activeFormStyles.buttonPaddingRight",
                    "fs.activeFormStyles.buttonPaddingBottom",
                    "fs.activeFormStyles.buttonPaddingLeft"
                ],
                "buttonMargin": [
                    "fs.activeFormStyles.buttonMarginTop",
                    "fs.activeFormStyles.buttonMarginBottom",
                    "fs.activeFormStyles.buttonMarginSide"
                ],
                "messagePadding": [
                    "fs.activeFormMessage.paddingTop",
                    "fs.activeFormMessage.paddingRight",
                    "fs.activeFormMessage.paddingBottom",
                    "fs.activeFormMessage.paddingLeft"
                ],
                "messageMargin": [
                    "fs.activeFormMessage.marginTop",
                    "fs.activeFormMessage.marginRight",
                    "fs.activeFormMessage.marginBottom",
                    "fs.activeFormMessage.marginLeft"
                ],
                imageMargin: [
                    "fs.activeElement.marginTop",
                    "fs.activeElement.marginBottom",
                    "fs.activeElement.marginSide"
                ]
            };
            self.ufFormActionsUrls = ufFormActionsUrls;
            self.lockersState = {};
            self.formState = "normal";
            self.formMessagesTypes = ['succmess', 'errmess', 'loadmess'];
            self.activeFormElements = {
                fields: [],
                buttons: []
            };
            self.activeElement = null;
            self.defaultBoxes = [];
            self.formSettings = formSettings;
            self.isOpen = {
                generalStyleSettings: true,
                generalSettings: true
            };
            self.availableElements = [
                {
                    title: "Add Form Fields",
                    elements: [
                        {
                            type: "text",
                            title: "Text Box"
                        }, {
                            type: "textarea",
                            title: "Text Area"
                        }, {
                            type: "radio",
                            title: "Radio Button"
                        }, {
                            type: "checkbox",
                            title: "Check Box"
                        }, {
                            type: "select",
                            title: "Select Box"
                        }
                        , {
                            type: "captcha",
                            title: "Captcha",
                            disabled: function () {
                                return self.activeFormElements.fields.some(function (el) {
                                    return el.type === "captcha";
                                });
                            }
                        }
                        , {
                            type: "image",
                            title: "Image"
                        },
                        {
                            type: "file",
                            title: "Upload File"
                        }
                    ]
                },
                {
                    title: "Add Text Fields",
                    elements: [{
                        type: "title",
                        title: "Title"
                    }, {
                        type: "paragraph",
                        title: "Description"
                    }]
                }
                //{
                //    title: "Add Row",
                //    elements: [{
                //        type: "row",
                //        title: "Horizontal Row",
                //        icon: "align-justify"
                //    }]
                //}
            ]
            self.dndConfig = {
                dragThreshold: 5
            };

            self.newElementsDragEvents = {
                dragStart: function () {
                    ng.element("#dropArea").addClass("dnd-in-progress");
                },
                dragStop: function () {
                    ng.element("#dropArea").removeClass("dnd-in-progress");
                },
                dragMove: function (e) {
                    e.elements.dragging.addClass("bs-wrapper").show();
                    e.elements.placeholder.addClass("button-ghost");
                },
                dropped: function (e) {
                    if (e.source.cloneModel.type === "image") {
                        selectImage().then(function (imgObj) {
                            self.activeFormElements.fields.splice(e.dest.index, 1, prepareElement("image", imgObj));
                        });
                    } else {
                        self.activeFormElements.fields.splice(e.dest.index, 1, prepareElement(e.source.cloneModel.type));
                    }
                }
            };

            self.formElementsDragEvents = {
                dragStart: function () {
                    ng.element("#dropArea").addClass("dnd-in-progress");
                },
                dragStop: function () {
                    ng.element("#dropArea").removeClass("dnd-in-progress");
                },
                dragMove: function (e) {
                    e.elements.placeholder.addClass("sortable-ghost");
                }
            };

            self.elementOptionsDragEvenets = {
                dragMove: function (e) {
                    e.elements.dragging.addClass("bs-wrapper").show();
                }
            };

            self.defaultElValues = ufElementsDefaultValues;

            function valOutput(style) {
                return typeof style === 'object' ? (style.value || 0) + (style.unit || 'px') : (style || 0) + "px";
            }

            self.assetsPath = $window.g_urlAssets;
            self.templateFields = $window.g_jsonTemplatesFields;
            self.templateStyles = $window.g_jsonTemplatesStyles;
            self.generalSettings = $window.g_jsonGeneralSettings;
            self.formId = $window.form.id;

            self.hideActiveElementSettings = function () {
                self.activeElement = null;
                self.activeFormElements.fields && self.activeFormElements.fields.forEach(function (el) {
                    delete el._active;
                });
                self.activeFormElements.buttons && self.activeFormElements.buttons.forEach(function (el) {
                    delete el._active;
                });
            }

            $scope.$on("$locationChangeSuccess", function (e, url) {
                self.hideActiveElementSettings();
            });

            self.selectedElTemplate = function () {
                var type = self.activeElement.type;
                if (type === "textarea") {
                    type = "text"
                }
                if (self.formMessagesTypes.indexOf(type) > -1) {
                    type = "message";
                }
                return "elements/" + type + ".html";
            };

            self.messageSettingsTemplate = function () {
                return "elements/message.html";
            };

            self.showFormMessage = function () {
                if (self.formState !== "normal") {
                    self.lockersState.messageMargin = false;
                    self.lockersState.messagePadding = false;
                    self.lockChanges('messageMargin');
                    self.lockChanges('messagePadding');
                    self.activeFormMessage = self.activeFormStyles[self.formState];
                }
            }

            self.elementActions = {
                setActive: function (e, el) {
                    Object.keys(self.defaultElValues[el.type], function (key) {
                        if (!key in el) {
                            el[key] = self.defaultElValues[el.type][key];
                        }
                    });
                    self.activeFormElements.fields.forEach(function (elm) {
                        elm._active = false;
                    });
                    el._active = true;
                    self.activeTab = null;
                    self.activeElement = prepareFormStyleValues(el);

                    if (["INPUT", "TEXTAREA", "SELECT"].indexOf(e.target.tagName) === -1)
                        self.focusInput = true;
                },
                copy: function (e, el) {
                    e.stopPropagation();
                    var copiedEl = ng.copy(el);
                    copiedEl._active = false;
                    self.activeFormElements.fields.splice(self.activeFormElements.fields.indexOf(el) + 1, 0, copiedEl);
                },
                remove: function (e, el) {
                    e.stopPropagation();
                    self.activeFormElements.fields.splice(self.activeFormElements.fields.indexOf(el), 1);
                    self.activeElement = null;
                }
            };

            self.activeFormStyles = prepareFormStyleValues(self.generalSettings);
            self.formMessagesTypes.forEach(function (mesType) {
                self.activeFormStyles[mesType] = prepareFormStyleValues(self.activeFormStyles[mesType]);
            });


            function getDescendantProp(obj, desc, value) {
                var arr = desc.split(".");
                while (arr.length - 1) {
                    obj = obj[arr.shift()]
                }
                if (typeof value !== "undefined")
                    obj[arr.shift()] = value;
                return obj[arr.shift()];
            }

            var lockedChanges = {};


            self.lockChanges = function (fieldsName) {
                if (self.lockersState[fieldsName]) {
                    var firstTime = true;
                    lockedChanges[fieldsName] = $scope.$watchGroup(fieldsForLock[fieldsName], function (newCol, oldCol) {
                        var changedValue = null;
                        if (firstTime) {
                            newCol.forEach(function (newVal, ni) {
                                if (+oldCol[ni] !== +newVal) {
                                    changedValue = +newVal;
                                }
                            });
                        } else {
                            var repeats = {};
                            newCol.forEach(function (newVal) {
                                if (!repeats[newVal]) repeats[newVal] = 0;
                                repeats[newVal]++;
                            });
                            Object.keys(repeats).forEach(function (newVal) {
                                if (repeats[newVal] === 1) {
                                    changedValue = newVal;
                                }
                            });
                        }
                        if (changedValue !== null) {
                            fieldsForLock[fieldsName].forEach(function (fieldName) {
                                getDescendantProp($scope, fieldName, changedValue);
                            });
                        }

                        firstTime = false;
                    });
                } else {
                    if (lockedChanges[fieldsName] && typeof lockedChanges[fieldsName] === "function")
                        lockedChanges[fieldsName]();
                }
            }

            self.revertDefaultFormStyles = function (el) {
                var defaultStyles = self.defaultElValues[el.type];
                if (typeof defaultStyles._from_form !== "undefined") {
                    Object.keys(defaultStyles._from_form).forEach(function (styleName) {
                        var inherritedStyle = ng.copy(defaultStyles._from_form[styleName]);
                        if (typeof inherritedStyle === 'object') {
                            Object.keys(inherritedStyle).forEach(function (subStyleKey) {
                                inherritedStyle[subStyleKey] = getStyleFromForm(inherritedStyle[subStyleKey]);
                            });
                            el[styleName] = ng.extend({}, el[styleName], inherritedStyle);
                        } else {
                            el[styleName] = getStyleFromForm(inherritedStyle)
                        }
                    });
                }
            };
            self.confirmChangeFormElements = function () {
                if (confirm("All unsaved changes will be replaced! Are you sure?")) {
                    self.activeFormElements = self._activeFormElements;
                }
            };

            self.confirmChangeFormStyles = function () {
                if (confirm("All unsaved changes will be replaced! Are you sure?")) {
                    self.activeFormStyles = prepareFormStyleValues(ng.copy(self._activeFormStyles));

                    var oneTimeChange = $scope.$watch(function () {
                        return self.activeFormStyles
                    }, function (n, o) {
                        if (n !== o) {
                            self._activeFormStyles = null;
                            oneTimeChange();
                        }
                    }, true)
                }
            };

            self.renderFormStyle = function () {
                var testForFormStyles = /^form(.+)$/;
                var fs = {};
                Object.keys(self.activeFormStyles).forEach(function (key) {
                    if (testForFormStyles.test(key)) {
                        fs[key] = self.activeFormStyles[key];
                    }
                });
                var styles = {
                    maxWidth: (fs.formFullWidth === "true") ? '100%' : (fs.formMaxWidth.value || 0) + fs.formMaxWidth.unit,
                    minWidth: (fs.formMinWidth.value || 0) + fs.formMinWidth.unit,
                    boxShadow: (fs.formShadowInset ? "inset" : "") + " " +
                    fs.formShadowColor + " " + valOutput(fs.formShadowH) + " " +
                    valOutput(fs.formShadowV) + " " + valOutput(fs.formShadowB),
                    border: valOutput(fs.formBorderWidth) + " " + fs.formBorderType + " " + fs.formBorderColor,
                    borderRadius: valOutput(fs.formBorderRadius),
                    padding: valOutput(fs.formPaddingTop) + " " + valOutput(fs.formPaddingRight) + " " +
                    valOutput(fs.formPaddingBottom) + " " + valOutput(fs.formPaddingLeft),
                    direction: fs.formDirection,
                    textAlign: fs.formDirection === 'rtl' ? "right" : "left"
                };

                if (fs.formBgType === "solid") {
                    styles.background = fs.formBgStartColor;
                } else if (fs.formBgType === "gradient") {
                    styles.backgroundImage = "linear-gradient(" + fs.formBgStartColor + ", " + fs.formBgEndColor + ")";
                } else {
                    styles.backgroundColor = fs.formBgStartColor;
                    styles.backgroundImage = "url(" + $window.g_urlRoot + fs.formBgImg + ")";
                    styles.backgroundSize = fs.formBgFit;
                    styles.backgroundRepeat = fs.formBgRepeat;
                    styles.backgroundPosition = fs.formBgPosition;
                }

                return styles;
            };

            self.getButtonElement = function (elements) {
                return elements.filter(function (el) {
                    return el.type === "button";
                })[0];
            };

            self.addEl = {
                title: function () {
                    pushElement("title");
                },
                paragraph: function () {
                    pushElement("paragraph");
                },
                select: function () {
                    pushElement("select");
                },
                checkbox: function () {
                    pushElement("checkbox");
                },
                radio: function () {
                    pushElement("radio");
                },
                text: function () {
                    pushElement("text");
                },
                textarea: function () {
                    pushElement("textarea");
                },
                captcha: function () {
                    pushElement("captcha");
                },
                row: function () {
                    pushElement("row");
                },
                image: function () {
                    selectImage().then(function (imgObj) {
                        pushElement("image", imgObj);
                    });
                },
                file: function () {
                    pushElement("file");
                },
            };

            function pushElement(elType, settings) {
                settings = settings || {};
                if (self.formState === "succmess") self.formState = "normal";
                if (elType === "title") {
                    self.activeFormElements.fields.unshift(prepareElement(elType, settings));
                } else if (elType === "paragraph") {
                    var title = self.activeFormElements.fields.filter(function (field) {
                        return field.type === "title"
                    })[0];
                    if (title) {
                        self.activeFormElements.fields.splice(self.activeFormElements.fields.indexOf(title) + 1, 0, prepareElement(elType, settings));
                    } else {
                        self.activeFormElements.fields.unshift(prepareElement(elType, settings));
                    }
                } else {
                    self.activeFormElements.fields.push(prepareElement(elType, settings));
                }

            }

            function prepareElement(elType, settings) {
                settings = settings || {};
                var newEl = ng.copy(self.defaultElValues[elType]);
                if (!newEl) return;
                newEl.id = elType + (new Date()).valueOf();

                if (typeof newEl._from_form !== "undefined") {
                    Object.keys(newEl._from_form).forEach(function (styleName) {
                        var inherritedStyle = ng.copy(newEl._from_form[styleName]);
                        if (typeof inherritedStyle === 'object') {
                            Object.keys(inherritedStyle).forEach(function (subStyleKey) {
                                inherritedStyle[subStyleKey] = getStyleFromForm(inherritedStyle[subStyleKey]);
                            });
                            newEl[styleName] = ng.extend(newEl[styleName] || {}, inherritedStyle);
                        } else {
                            newEl[styleName] = getStyleFromForm(inherritedStyle)
                        }
                    });
                }
                delete newEl._from_form;
                return prepareFormStyleValues(ng.extend(newEl, settings));
            }

            function getStyleFromForm(styleName) {
                return ng.copy(self.activeFormStyles[styleName]);
            }

            function mergeValuesAndUnits(el) {
                Object.keys(el).forEach(function (key) {
                    if (typeof el[key] === "object") {
                        el[key] = mergeValuesAndUnits(el[key]);
                    }
                    if (typeof el[key].value !== 'undefined' && typeof el[key].unit !== 'undefined') {
                        el[key] = el[key].value + el[key].unit;
                    }
                });
                return el;
            }

            function prepareFormStyleValues(form) {
                var testForUnits = /^(\d+)(PX|%)$/i;
                Object.keys(form).forEach(function (key) {
                    var match = testForUnits.exec(form[key]);
                    if (match !== null) {
                        form[key] = {
                            value: parseFloat(match[1]),
                            unit: match[2]
                        };
                    } else {
                        if (parseFloat(form[key]).toString() === form[key]) {
                            form[key] = parseFloat(form[key]);
                        }
                    }
                });
                return form;
            }

            self.onlyTextFields = function (item) {
                return ["text"].indexOf(item.type) > -1;
            }

            self.optionActions = {
                model: {},
                _generateValueFromLabel: function (label, otherLabels) {
                    var generatedValue = label.replace(/\W+/g, '_').toLowerCase();
                    if (otherLabels.indexOf(generatedValue) > -1) {
                        generatedValue += "_" + (new Date).valueOf();
                    }
                    return generatedValue;
                },
                setChecked: function (opt) {
                    if (['radio', 'select'].indexOf(self.activeElement.type) > -1) {
                        self.activeElement.options.forEach(function (o) {
                            o.checked = false;
                        });
                        opt.checked = true;
                    } else {
                        opt.checked = !opt.checked;
                    }
                },
                updateValue: function (opt, options) {
                    opt.value = this._generateValueFromLabel(opt.label, options.filter(function (o) {
                        return o !== opt;
                    }).map(function (o) {
                        return o.value
                    }));
                },
                remove: function (opt) {
                    self.activeElement.options = self.activeElement.options.filter(function (o) {
                        return o !== opt;
                    });
                    if (self.activeElement.type === "radio" && opt.checked && self.activeElement.options.length > 0) {
                        self.activeElement.options[0].checked = true;
                    }
                },
                add: function (form, options) {
                    if (form.$valid && form.$dirty) {
                        this.model.value = this._generateValueFromLabel(this.model.label, options.map(function (o) {
                            return o.value
                        }));
                        self.activeElement.options.push(this.model);
                        this.model = {};
                        form.$setPristine();
                        form.$setUntouched();
                    }
                }
            }
            self.aspectRatio = {
                changedWidth: function () {
                    if (self.activeElement.keepRatio == "true") {
                        self.activeElement.height.value = Math.ceil(self.activeElement.width.value / self.activeElement._aspectRatio);
                    }
                },
                changedHeight: function () {
                    if (self.activeElement.keepRatio == "true") {
                        self.activeElement.width.value = Math.ceil(self.activeElement.height.value * self.activeElement._aspectRatio);
                    }
                },
                returnOriginal: function () {
                    self.activeElement.height.value = ng.copy(self.activeElement._original.height);
                    self.activeElement.width.value = ng.copy(self.activeElement._original.width);
                    self.activeElement.height.unit = "px";
                    self.activeElement.width.unit = "px";
                },
                isDisabled: function () {
                    return self.activeElement.height.value === self.activeElement._original.height &&
                        self.activeElement.width.value === self.activeElement._original.width &&
                        self.activeElement.height.unit === "px" &&
                        self.activeElement.width.unit === "px";
                }
            };
            function loadFormFields() {
                var request = formService.get(self.formId);
                request.then(function (response) {
                    try {
                        response = Object.keys(response).map(function (key) {
                            return prepareFormStyleValues(response[key])
                        });
                        self.activeFormElements.fields = response.filter(function (el) {
                            return ['button', 'succmess', 'errmess', 'loadmess'].indexOf(el.type) === -1;
                        });

                        self.activeFormElements.buttons = response.filter(function (el) {
                            return el.type === "button";
                        });

                        if (self.activeFormElements.fields.length === 0) self.activeFormElements.fields = [];
                        if (self.activeFormElements.buttons.length === 0) self.activeFormElements.buttons = [self.defaultElValues.button];

                        _cachedFormElements = ng.copy(self.activeFormElements);
                        _cachedFormStyles = ng.copy(self.activeFormStyles);
                    } catch (e) {
                        $scope.$emit("add alert", {
                            type: "danger",
                            msg: "Unable to load form."
                        });
                    }
                });
                return request;
            }

            function loadFormStylesAndSettings() {
                var request = formService.getStyles(self.formId);
                request.then(function (response) {
                    try {
                        self.activeFormStyles = prepareFormStyleValues(response.styles);
                        self.formMessagesTypes.forEach(function (mesType) {
                            self.activeFormStyles[mesType] = prepareFormStyleValues(self.activeFormStyles[mesType]);
                        });

                        formSettings = response.settings;

                        _cachedFormSetting = ng.copy(formSettings);
                        _cachedFormStyles = ng.copy(self.activeFormStyles);
                    } catch (e) {
                        $scope.$emit("add alert", {
                            type: "danger",
                            msg: "Unable to load form styles."
                        });
                    }
                });
                return request;
            }

            function checkForRecommendedFields(quite) {
                return $q(function (resolve, reject) {
                    if (quite) {
                        resolve();
                        return;
                    }
                    var emptyRecomFields = $window.formOptions.filter(function (field) {
                        return field.recommanded && field.recommanded === "true" && (!self.formSettings[field.name] || self.formSettings[field.name].length === 0)
                    });

                    if (emptyRecomFields.length > 0) {
                        var modalInstance = $uibModal.open({
                            animation: true,
                            templateUrl: 'confirm-recommended.html',
                            controller: 'RecommendedModalInstanceCtrl',
                            resolve: {
                                fields: function () {
                                    return emptyRecomFields
                                }
                            }
                        });
                        modalInstance.result.then(resolve, reject);
                    } else {
                        resolve();
                    }
                })
            }

            self.resetForm = function () {
                self.activeFormElements = ng.copy(_cachedFormElements);
                self.activeFormStyles = ng.copy(_cachedFormStyles);
                $location.path("/formStyle");
            };

            self.clearForm = function () {
                self.activeFormElements.fields = [];
                $location.path("/formStyle");
            };


            self.gotoStyling = function (section) {
                var timeout = 1000;
                if (self.isOpen[section] === true) {
                    timeout = 0;
                } else {
                    Object.keys(self.isOpen).forEach(function (sect) {
                        self.isOpen[sect] = false;
                    });
                    self.isOpen[section] = true;
                }

                self.hideActiveElementSettings();

                $location.path("/formStyle");

                var ngSection = ng.element("#section-" + section);
                if (section && ngSection.length > 0) {
                    setTimeout(function () {
                        ng.element(".uf-settings-block")[0].scrollTop = ngSection[0].offsetTop - 46;
                    }, timeout)
                }
            };

            self.showFormResize = false;
            $timeout(function () {
                ng.element("input[data-ng-model$='formMaxWidth.value']").on("focus", function () {
                    self.showFormResize = true;
                    $scope.$digest();
                }).on("blur", function () {
                    if (!ng.element(".uf-form").hasClass("uf-resizing")) {
                        self.showFormResize = false;
                        $scope.$digest();
                    }
                });
            }, 100);

            $scope.$on("elementResize:end", function (e, obj) {
                if (obj.element[0] === ng.element(".uf-form")[0]) {
                    ng.element("input[data-ng-model$='formMaxWidth.value']").trigger("focus");
                }
            });

            $scope.$on("farbastic:open", function (e, data) {
                if (data.modelName.split(".").pop() === "fieldTextColor") {
                    var textFields = self.activeFormElements.fields.filter(function (el) {
                        return ["text", "textarea"].indexOf(el.type) > -1;
                    });

                    if (textFields.every(function (el) {
                            return el.value.length === 0;
                        })) {
                        textFields.forEach(function (el) {
                            el.value = "Sample text";
                            el._setSampleText = true;
                        });
                        $scope.$digest();
                    }
                }
            });

            $scope.$on("farbastic:close", function (e, data) {
                if (data.modelName.split(".").pop() === "fieldTextColor") {
                    self.activeFormElements.fields.forEach(function (el) {
                        if (el._setSampleText) {
                            el.value = "";
                            delete el._setSampleText;
                        }
                    });
                }
            });

            $scope.$on("visual:saveTemplate", function () {
                var modalInstance = $uibModal.open({
                    animation: true,
                    templateUrl: 'save-template.html',
                    controller: 'SaveTemplateModalInstanceCtrl',
                    resolve: {
                        form: function () {
                            return {
                                name: formSettings.form_title,
                                alias: formSettings.form_alias
                            }
                        }
                    }
                });
                modalInstance.result.then(function (form) {
                    var formToSave = mergeValuesAndUnits(ng.copy(self.activeFormStyles));
                    self.templateStyles[form.alias] = {
                        title: form.name,
                        params: formToSave
                    };
                    formService.saveTemplate(form, formToSave).then(function (responseMessage) {
                        $scope.$emit("add alert", {
                            type: "success",
                            msg: responseMessage
                        });
                    });
                });
            });

            $scope.$on("navigation start", function (e, tab) {
                self.hideActiveElementSettings();
                if (tab.id === "preview") {
                    if (
                        !ng.equals(self.activeFormElements, _cachedFormElements) ||
                        !ng.equals(self.activeFormStyles, _cachedFormStyles) ||
                        !ng.equals(self.formSettings, _cachedFormSetting)
                    ) {
                        saveForm(true).then(function () {
                            $scope.$emit("navigation continue", tab.url);
                        });
                    } else {
                        $scope.$emit("navigation continue", tab.url);
                    }
                }
            });

            $scope.$on("settings:saveSettings", function(){
                saveForm();
            });

            $scope.$watch(function () {
                return self.activeFormStyles;
            }, function (n, o) {
                if (n) {
                    ["Top", "Right", "Bottom", "Left"].forEach(function (dir) {
                        if (["Right", "Left"].indexOf(dir) > -1) {
                            self.activeFormStyles.loadmess["margin" + dir] = self.activeFormStyles["buttonMarginSide"];
                        } else {
                            self.activeFormStyles.loadmess["margin" + dir] = self.activeFormStyles["buttonMargin" + dir];
                        }
                        self.activeFormStyles.loadmess["padding" + dir] = self.activeFormStyles["buttonPadding" + dir] +
                            (self.activeFormStyles.buttonBorderType !== "none" ? self.activeFormStyles.buttonBorderSize : 0);
                    })
                }
            }, true);


            $scope.$watch(function () {
                return self.activeFormStyles.formFullWidth
            }, function (n) {
                if (n === "true") {
                    self.activeFormStyles.formMaxWidth.value = 100;
                    self.activeFormStyles.formMaxWidth.unit = "%";
                }
            });

            $scope.$watch(function () {
                return self.emptyRequiredFields;
            }, function () {
                $scope.$emit("settings:requiredFields", self.emptyRequiredFields);
            });

            $scope.$watch(function () {
                return formSettings.form_alias
            }, function (alias) {
                if (typeof alias === "undefined") {
                    self.formSettings.form_shortcode = "Please enter form alias";
                } else {
                    self.formSettings.form_shortcode = "{uniteforms " + alias + "}";
                }
            });


            function selectImage() {
                return $q(function (resolve, reject) {
                    ufImageBrowserService.openImgBrowser().then(function (value) {
                        var img = new Image();
                        img.onload = function () {
                            resolve({
                                imgSrc: value,
                                height: {
                                    value: this.height,
                                    unit: "px"
                                },
                                width: {
                                    value: this.width,
                                    unit: "px"
                                },
                                _original: {
                                    height: this.height,
                                    width: this.width
                                },
                                _aspectRatio: this.width / this.height
                            });
                        }
                        img.src = $window.g_urlRoot + value;
                    });
                })
            }

            function saveForm(quite) {
                $scope.$emit("clear alerts");

                self.emptyRequiredFields = [];
                if (self.optionsForm.$invalid && !quite) {
                    self.emptyRequiredFields = $window.formOptions.filter(function (option) {
                        return self.optionsForm.$error.required.some(function (field) {
                            if (field.$name === option.name) {
                                return option.required === "true";
                            }
                        });
                    });
                    if (self.emptyRequiredFields.length > 0) {
                        return;
                    }
                }

                return $q(function (resolve, reject) {
                    checkForRecommendedFields(quite).then(function () {
                        var formOptions = {};
                        $window.formOptions.forEach(function (option) {
                            formOptions[option.name] = self.formSettings[option.name];
                        });

                        var formElements = ng.copy([].concat(self.activeFormElements.fields, self.activeFormElements.buttons));
                        formElements = formElements.map(function (el) {
                            delete el._active;
                            return mergeValuesAndUnits(el);
                        });
                        var formStyles = mergeValuesAndUnits(ng.copy(self.activeFormStyles));

                        var request = formService.save(self.formId, formStyles, formElements, formOptions);
                        request.then(function (responseMessage) {
                            $scope.$emit("add alert", {
                                type: "success",
                                msg: responseMessage
                            });
                            _cachedFormElements = ng.copy(self.activeFormElements);
                            _cachedFormStyles = ng.copy(self.activeFormStyles);
                            _cachedFormSetting = ng.copy(self.formSettings);
                            resolve();
                        }, function (responseMessage) {
                            $scope.$emit("add alert", {
                                type: "danger",
                                msg: responseMessage
                            });
                            reject();
                        });
                    });
                });
            }

            self.deleteForm = function () {
                var modalInstance = $uibModal.open({
                    animation: true,
                    templateUrl: 'confirm-form-delete.html'
                });
                modalInstance.result.then(function () {
                    formService.delete(self.formId).then(function (response) {
                        $scope.$emit("add alert", {
                            type: "success",
                            msg: response
                        });
                        $timeout(function () {
                            $window.location = ufFormActionsUrls.formsView;
                        }, 1000)
                    });
                });
            };

            self.exportForm = function () {
                formService.export(self.formId);
            };

            self.importForm = function () {
                var modalInstance = $uibModal.open({
                    animation: true,
                    templateUrl: 'import-form.html',
                    controller: 'ImportFormModalInstanceCtrl'
                });
                modalInstance.result.then(function (file) {
                    self.loading = true;
                    formService.import(self.formId, file).then(function (response) {
                        $q.all([
                            loadFormFields(),
                            loadFormStylesAndSettings()
                        ]).then(function(){
                            $scope.$emit("add alert", {
                                type: "success",
                                msg: response
                            });
                        }).finally(function(){
                            self.loading = false;
                        })
                    });
                });
            };

            self.loading = true;
            loadFormFields().finally(function(){
                self.loading = false;
            });
        }
    ]);

    app.controller("SaveTemplateModalInstanceCtrl", ["$scope", "$uibModalInstance", "form", function ($scope, $uibModalInstance, form) {
        $scope.form = form;
    }]);

    app.controller('RecommendedModalInstanceCtrl', ["$scope", "$uibModalInstance", "fields", function ($scope, $uibModalInstance, fields) {
        $scope.fields = fields;
    }]);

    app.controller('ImportFormModalInstanceCtrl', ["$scope", "$uibModalInstance", function ($scope, $uibModalInstance) {
        $scope.upload = function (form) {
            if (form.file.$dirty && form.file.$valid) {
                $uibModalInstance.close($scope.file);
            }
        }
    }]);
})
(angular, jQuery);