(function(ng){
    'use strict';

    var app = ng.module("ufApp.controllers.formsListCtrl", []);
    app.controller("formsListCtrl", ["$scope", "$window", "$http", "formService", "$timeout", "ufFormActionsUrls", "$uibModal",
        function($scope, $window, $http, formService, $timeout, ufFormActionsUrls, $uibModal){
        var self = this;
        self.alerts = [];
        self.ufFormActionsUrls = ufFormActionsUrls;
        self.closeAlert = function(index) {
            self.alerts.splice(index, 1);
        };

        $scope.$on("add alert", function (e, alert) {
            self.alerts = [];
            self.alerts.push(alert);
        });

        self.deleteForm = function(form){
            var modalInstance = $uibModal.open({
                animation: true,
                templateUrl: 'confirm-form-delete.html'
            });
            modalInstance.result.then(function () {
                self.loading = true;
                formService.delete(form.id).then(function(response){
                    self.formsList = self.formsList.filter(function(f){
                        return f.id !== form.id;
                    });
                    self.alerts.push({
                        type: "success",
                        msg: response
                    });
                    self.loading = false;
                });
            });
        };

        self.createForm = function(){
            self.loading = true;
            formService.create().then(function(response){
                self.alerts.push({
                    type: "success",
                    msg: response
                });
                $timeout(function(){
                    loadForms()
                }, 2000);
            }).finally(function(){
                self.loading = false;
            });
        };

        self.copyForm = function(form){
            self.loading = true;
            formService.copy(form.id).then(function(response){
                self.alerts.push({
                    type: "success",
                    msg: response
                });
                $timeout(function(){
                    loadForms()
                }, 2000);
            }).finally(function(){
                self.loading = false;
            });
        }


        function loadForms(){
            self.loading = true;
            formService.list().then(function(response){
                self.formsList = response;
                self.alerts = [];
            }).finally(function(){
                self.loading = false;
            });
        }

        loadForms();
    }]);
})(angular);
