function trace(str) {
    console.log(str);
}

function UniteForms() {
    var g_formID;
    var g_formIDClear;
    var g_formIDDB;
    var g_options;
    var t = this;

    /**
     * initialize the form
     */
    t.init = function (formID, formIDDB, options) {
    	
        g_formIDClear = formID;
        g_formID = "#" + formID + " ";
        g_formIDDB = formIDDB;
        g_options = options;
        jQuery(g_formID + ".uf-sendbutton").click(sendButtonClick);

        var inputsWPlaceholder = jQuery(".uf-input-has-placeholder");
        jQuery.each(inputsWPlaceholder, function(){
            if(jQuery(this).val().length > 0)
                jQuery(this).siblings(".uf-input-placeholder").hide();
        });
        
        inputsWPlaceholder.on("focus", function(){
            jQuery(this).siblings(".uf-input-placeholder").hide();
        });
        
        inputsWPlaceholder.on("blur", function(){
            if(jQuery(this).val().length === 0)
                jQuery(this).siblings(".uf-input-placeholder").show();
        });
    }

    
    /**
     * get form data object from form elements
     */
    var getFormData = function () {

        var formID = g_formIDClear;

        var obj = new Object();
        var form = document.getElementById(formID);

        if (form === null) {
            trace("no form with id: " + formID + " found!");
            return (false);
        }

        var name, value, type, flagUpdate;

        //enabling all form items connected to mx
        var len = form.elements.length;
                
        for (var i = 0; i < len; i++) {
            var element = form.elements[i];

            name = element.name;
            value = element.value;

            type = element.type;

            if (type == "button")
                continue;

            if (jQuery(element).hasClass("wp-editor-area"))
                type = "editor";


            flagUpdate = true;

            switch (type) {
                case "checkbox":
                case "radio":
                    if (element.checked == false)
                        flagUpdate = false;
                    break;
                case "editor":
                    value = tinyMCE.get(name).getContent();
                    break;
                case "select-multiple":
                    value = jQuery(element).val();
                    if (value)
                        value = value.toString();
                    break;
            }

            if (flagUpdate == true && name != undefined) {
            	            	
            	if(obj.hasOwnProperty(name)){
            		obj[name] += "," + value;
            	}else
            		obj[name] = value;
                
            }
        }

        return (obj);
    }


    /**
     * show error message
     */
    var showErrorMessage = function (str) {
        jQuery(g_formID + ".uf-sendbutton").show();
        jQuery(g_formID + ".uf-error-message").toggleClass("hidden").html(str);
    }


    /**
     * show success message
     */
    var showSuccessMessage = function (str) {
        jQuery(g_formID + ".uf-formcontent").hide();
        jQuery(g_formID + ".uf-confirm-message").html(str).show();
    }


    /**
     * put debug message
     */
    var putDebug = function (str) {

        var objDebug = jQuery("#div_debug");
        if (objDebug.length > 0)
            objDebug.html(str);
    }


    /**
     * operate the form send action
     */
    var sendButtonClick = function () {
        
    	//get form data
        var data = {};
    	
        data.fields = getFormData();
        data.formID = g_formIDDB;

        var jsonData = JSON.stringify(data);

    	var objData = new FormData();
    	objData.append("client_action", "sendform");
    	objData.append("data", jsonData);
    	
    	//add attachment files
    	var objForm = jQuery("#"+g_formIDClear);
    	var objFiles = objForm.find("input[type='file']");
    	jQuery.each(objFiles, function(index, objFile){
    		var fieldName = objFile.name;
    		
    		jQuery.each(objFile.files, function(index2, file){
    			objData.append(fieldName, file);
    		});
    	});

        jQuery(g_formID + ".uf-sendbutton").hide();
        jQuery(g_formID + ".uf-sending-message").toggleClass("hidden", false);
        jQuery(g_formID + ".uf-error-message").toggleClass("hidden", true);

        //send contact form using ajax
        jQuery.ajax({
            url: g_options.url_ajax,
            global: false,
            type: "POST",
            data: objData,
            dataType: 'json',
            
            processData: false,
            contentType: false,
            
            success: function (response) {
            	
                //hide loader
                jQuery(g_formID + ".uf-sending-message").toggleClass("hidden");

                if (!response) {
                    showErrorMessage("Empty ajax response!");
                    return (false);
                }

                if (response == -1) {
                    showErrorMessage("ajax error!!!");
                    return (false);
                }

                if (response.success == undefined) {
                    showErrorMessage("The 'success' param is a must!");
                    return (false);
                }

                if (response.success == false) {
                    showErrorMessage(response.message);
                    return (false);
                }
                else {	//send success
                	
                	if(response.redirect_link && response.redirect_link != "")
                		location.href = response.redirect_link;
                	else
                		showSuccessMessage(response.message);
                }

            },
            error: function (jqXHR, textStatus, errorThrown) {

                jQuery(g_formID + ".uf-sending-message").toggleClass("hidden");

                if (textStatus == "parsererror")
                    putDebug(jqXHR.responseText);

                showErrorMessage("Ajax Error!!! " + textStatus);
            }
        });
    }


}