<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


	class UniteSettingsProductForms extends UniteSettingsOutputForms {
        	
		
		/**
		 * draw text as input
		 */
		public function drawTextInput($setting) {
			$disabled = "";
			$style="";
			$readonly = "";

			$settingName = $setting["name"];
			$settingID = $setting["id"];
			$settingValue = $setting["value"];

			if(isset($setting["style"])) 
				$style = "style='".$setting["style"]."'";
			if(isset($setting["disabled"])) 
				$disabled = 'disabled="disabled"';
				
			if(isset($setting["readonly"])){
				$readonly = "readonly='readonly'";
			}
			
			$class = "regular-text";
			$unitsGroupClass = "";
			if(isset($setting["class"]) && !empty($setting["class"])){
				$class = $setting["class"];
				
				//convert short classes:
				switch($class){
					case "small":
						$class = "small-text";
					break;
					case "code":
						$class = "regular-text code";
					break;
					case "input-sm":
						$unitsGroupClass = " btn-group-sm";
				}
			}
			$class .= " form-control";
            // class
			if(!empty($class)) {
				$class = "class='$class'";
            }

            // extra params
			$addParams = UniteFunctionsForms::getVal($setting, "addparams");

            // units
			$unit = UniteFunctionsForms::getVal($setting, "unit");
			$inputUnit = UniteFunctionsForms::getVal($setting, "input-unit");
			$hasUnits = UniteFunctionsForms::getVal($setting,"hasunits");
			$hasUnits = UniteFunctionsForms::strToBool($hasUnits);
			$readonly = UniteFunctionsForms::getVal($setting,"readonly");
			$readonly = UniteFunctionsForms::strToBool($readonly);

			if($hasUnits == true){
				$units1Value = UniteFunctionsForms::getVal($setting, "unit1","px");
				$units2Value = UniteFunctionsForms::getVal($setting, "unit2","%");
				
				$units1Class = " active";
				$units2Class = "";
				$settingValue = strtolower($settingValue);
				$settingValueNum = intval($settingValue);
				
				if(strlen($settingValue) > strlen($settingValueNum)){
					$settingUnit = substr($settingValue, strlen($settingValueNum));
					if(strtolower($settingUnit) == strtolower($units2Value)){
						$units1Class = "";
						$units2Class = " active";
					}
				}
			}

            // validation, Required and title  recommended datas
            $validation     = UniteFunctionsForms::getVal($setting,'validation', '');
            $req            = UniteFunctionsForms::getVal($setting,'required', 'false');
            $text           = UniteFunctionsForms::getVal($setting,'text', 'a field');
            $recommended    = UniteFunctionsForms::getVal($setting,'recommanded', 'false');
            $ngModelAttr = "";
            $value = "";
            $ngModelOptions = "";
            $ngMaxPercent = "";
            $readonlyAttr = $readonly ? "readonly" : "";
            $ngSpinner = ($hasUnits || $inputUnit) ? "data-uf-input-spinner" : "";
			if(!is_null($setting['ngModel'])){
				$changeDebounce = UniteFunctionsForms::getVal($setting,"change-debounce", 0);
				if($changeDebounce > 0){
					$ngModelOptions = "{'debounce': {$changeDebounce}}";
				}
				if($ngModelOptions){
					$ngModelOptions = "data-ng-model-options=\"{$ngModelOptions}\"";
				}

				if($hasUnits){
					$ngModelAttr = "data-ng-model=\"" . $setting['ngModel'] . ".value\"";
					$ngMaxPercent = "data-uf-input-max-percent=\"{{" . $setting['ngModel'] . ".unit}}\"";
				} else {
					$ngModelAttr = "data-ng-model=\"" . $setting['ngModel'] . "\"";
				}
			} else {
				$value = "value=\"" . $settingValue . "\"";
			}
			if($hasUnits || $inputUnit): ?>
				<div class="input-group">
    		<?php endif; ?>
				<input type="text" <?php
                        echo join(" ", array($class, $style, $disabled, $readonly, $addParams, $ngModelAttr, $value, $ngModelOptions, $ngSpinner, $ngMaxPercent, $readonlyAttr))?>
                        data-required="<?php echo $req;?>"
                        data-validation="<?php echo $validation;?>"
                        data-title="<?php echo $text;?>"
                        id="<?php echo $settingID;?>"
                        name="<?php echo $settingName;?>"
                        data-recommended="<?php echo $recommended?>"
                          />

			<?php if(!empty($unit)):
			?>
                <div class="help-inline">
                    <?php echo $unit?>
                </div>
			<?php 			
			endif;
			if($hasUnits == true):
			?>
                <div class="input-group-btn div_units <?php echo $unitsGroupClass?>" id="<?php echo $settingID?>Units" data-uib-dropdown>
                	<button type="button" class="btn btn-default dropdown-toggle" data-uib-dropdown-toggle>{{<?php echo $setting['ngModel']?>.unit | uppercase}} <span class="caret"></span></button>
					<ul class="dropdown-menu dropdown-menu-right" data-uib-dropdown-menu>
					  <li><a href="javascript:void(0)" ng-click="<?php echo $setting['ngModel'] . ".unit='" . $units1Value . "'" ?>"><?php echo strtoupper($units1Value)?></a></li>
					  <li><a href="javascript:void(0)" ng-click="<?php echo $setting['ngModel'] . ".unit='" . $units2Value . "'" ?>"><?php echo strtoupper($units2Value)?></a></li>
					</ul>
				</div>
			</div>
			<?php 
			endif;

			if($inputUnit){
				?>
				<span class="input-group-addon"><?php echo $inputUnit?></span>
				</div>
				<?php
			}
		}
		
		
		/**
		 * 
		 * draw imaeg input:
		 * @param $setting
		 */
		public function drawImageInput($setting){
            $ngModelAttr = "";
            if(!is_null($setting['ngModel'])){
                $ngModelAttr = "data-ng-model=\"" . $setting['ngModel'] . "\"";
            }
			?>
			<div data-uf-image-browse <?php echo $ngModelAttr?>></div>
			<?php
		}
		
		
		//-----------------------------------------------------------------------------------------------
		//draw a color picker
		public function drawColorPickerInput($setting){			
			$bgcolor = $setting["value"];
			$bgcolor = str_replace("0x","#",$bgcolor);


			$disabled = "";
			if(isset($setting["disabled"])){
				$color = "";
				$disabled = 'disabled="disabled"';
			}

            // validation, Required and title  recommended datas
            $validation = UniteFunctionsForms::getVal($setting,'validation', '');
            $req        = UniteFunctionsForms::getVal($setting,'Required', 'false');
            $text       = UniteFunctionsForms::getVal($setting,'text', 'a field');
            $recommended    = UniteFunctionsForms::getVal($setting,'Required', 'false');
			$ngModelAttr = "";
			if(!is_null($setting['ngModel'])){
				$ngModelAttr = "ng-model=\"" . $setting['ngModel'] . "\"";
			}
			?>
				<input type="text" ng-farbtastic
                       class="form-control"
                       id="<?php echo $setting["id"]?>"
                       <?php echo $ngModelAttr?>
                    	name="<?php echo $setting["name"]?>"
                       value="<?php echo $bgcolor?>" <?php echo $disabled?>/>
			<?php
		}
		
		//-----------------------------------------------------------------------------------------------
		// draw setting input by type
		public function drawInputs($setting){
			switch($setting["type"]){
				case UniteSettingsForms::TYPE_TEXT:
					$this->drawTextInput($setting);
				break;
				case UniteSettingsForms::TYPE_COLOR:
					$this->drawColorPickerInput($setting);
				break;
				case UniteSettingsForms::TYPE_SELECT:
					$this->drawSelectInput($setting);
				break;
				case UniteSettingsForms::TYPE_CHECKBOX:
					$this->drawCheckboxInput($setting);
				break;
				case UniteSettingsForms::TYPE_RADIO:
					$this->drawRadioInput($setting);
				break;
				case UniteSettingsForms::TYPE_TEXTAREA:
					$this->drawTextAreaInput($setting);
				break;
				case UniteSettingsForms::TYPE_ORDERBOX:
					$this->drawOrderbox($setting);
				break;
				case UniteSettingsForms::TYPE_ORDERBOX_ADVANCED:
					$this->drawOrderbox_advanced($setting);
				break;
				case UniteSettingsForms::TYPE_IMAGE:
					$this->drawImageInput($setting);
				break;
				case UniteSettingsForms::TYPE_CHECKBOXGROUP:
					$this->drawCheckboxGroupInput($setting);
				break;
				case UniteSettingsForms::TYPE_CUSTOM:
					if(method_exists($this,"drawCustomInputs") == false){
						UniteFunctionsForms::throwError("Method don't exists: drawCustomInputs, please override the class");
					}
					$this->drawCustomInputs($setting);
				break;
				default:
					throw new Exception("wrong setting type - ".$setting["type"]);
				break;
			}			
		}		
		
		
		
		//-----------------------------------------------------------------------------------------------
		// draw text area input
		
		public function drawTextAreaInput($setting){
			
			$disabled = "";
			if (isset($setting["disabled"])) $disabled = 'disabled="disabled"';
			
			$style = "";
			if(isset($setting["style"]))
				$style = "style='".$setting["style"]."'";

			$rows = UniteFunctionsForms::getVal($setting, "rows");
			if(!empty($rows))
				$rows = "rows='$rows'";
				
			$cols = UniteFunctionsForms::getVal($setting, "cols");
			if(!empty($cols)) {
				$cols = "cols='$cols'";
            }


            // validation, Required and title  recommended datas
            $validation = UniteFunctionsForms::getVal($setting,'validation', '');
            $req        = UniteFunctionsForms::getVal($setting,'Required', 'false');
            $text       = UniteFunctionsForms::getVal($setting,'text', 'a field');
            $recommended    = UniteFunctionsForms::getVal($setting,'Required', 'false');
			$ngModelAttr = "";
			if(!is_null($setting['ngModel'])){
				$ngModelAttr = "ng-model=\"" . $setting['ngModel'] . "\"";
			}

			?>
				<textarea id="<?php echo $setting["id"]?>"
                          name="<?php echo $setting["name"]?>"
                          <?php echo join(" ", array($style, $disabled, $rows, $cols, $ngModelAttr))?>
                          data-required="<?php echo $req;?>"
                          data-validation="<?php echo $validation;?>"
                          data-recommended="<?php echo $recommended?>"
                          data-title="<?php echo $text;?>" class="form-control"><?php echo $setting["value"]?></textarea>
			<?php
			if(!empty($cols))
				echo "<br>";	//break line on big textareas.
		}		
		
		//-----------------------------------------------------------------------------------------------
		// draw radio input
		public function drawRadioInput($setting){
			$items = $setting["items"];

            // validation, Required and title  recommended datas
            $validation = UniteFunctionsForms::getVal($setting,'validation', '');
            $req        = UniteFunctionsForms::getVal($setting,'Required', 'false');
            $masterText       = UniteFunctionsForms::getVal($setting,'text', 'a field'); // '$text' is in use in the loop, so use different name to distinguish
            $recommended    = UniteFunctionsForms::getVal($setting,'Required', 'false');

			$ngModelAttr = "";
			if($setting['ngModel']){
				$ngModelAttr = "ng-model=\"" . $setting['ngModel'] . "\"";
			}
			$counter = 0;
			foreach($items as $item):
				$checked = "";
				if($setting['ngModel']){
					$valueAttr = "ng-value=\"'" . $item['value'] . "'\"";
				} else {
					$valueAttr = "value=\"" . $item['value'] . "\"";
					if($item['value'] == $setting["value"]) $checked = " checked";
				}
				$counter++;
				$radioID = $setting["id"]."_".$counter;
				?>
				<label class="radio-inline">
					<input type="radio"
                           id="<?php echo $radioID?>"
                           name="<?php echo $setting["name"]?>"
                           required="<?php echo $req;?>"
                           data-validation="<?php echo $validation;?>"
                           title="<?php echo $masterText;?>"
                           option="<?php echo $counter;?>"
                           data-recommended="<?php echo $recommended?>"
                          <?php
                          	echo join(" ", array($checked, $ngModelAttr, $valueAttr))
                          ?>/>
					<?php echo $item['text']?></label>
				<?php				
			endforeach;
			?>
			<?php 
		}
		
		
		//-----------------------------------------------------------------------------------------------
		// draw checkbox
		public function drawCheckboxInput($setting){
			$checked = "";

            // validation, Required and title  recommended datas
            $validation = UniteFunctionsForms::getVal($setting,'validation', '');
            $req        = UniteFunctionsForms::getVal($setting,'Required', 'false');
            $text       = UniteFunctionsForms::getVal($setting,'text', 'a field');
            $recommended    = UniteFunctionsForms::getVal($setting,'Required', 'false');
            $ngModelAttr = "";
			if($setting['ngModel']){
				$ngModelAttr = "ng-model=\"" . $setting['ngModel'] . "\"";
			}
			$req = $req === "true" ? "required" : ""
			?>
				<input type="checkbox"
                       id="<?php echo $setting["id"]?>"
                       name="<?php echo $setting["name"]?>"
                       <?php echo join(" ", array($ngModelAttr, $req))?>
                       ng-true-value="'true'"
                       ng-false-value="'false'"
                       />
			<?php
		}		

		public function drawCheckboxGroupInput($setting){
			?>
                <div class="checkbox-group">
                <?php foreach($setting["items"] as $item): ?>
                    <label class="btn" ng-model="<?php echo $setting['ngModel']?>.<?php echo $item['value']?>"
                        title="<?php echo $item['text']?>" uib-btn-checkbox btn-checkbox-true="'true'"
                        btn-checkbox-false="'false'">
                        <i class="fa fa-<?php echo $item['value']?>"></i>
                    </label>
                    <?php endforeach; ?>
                </div>
            <?php
		}

		//-----------------------------------------------------------------------------------------------
		//draw select input

		public function drawSelectInput($setting){

            // validation, Required and title  and recommanded datas
            $validation     = UniteFunctionsForms::getVal($setting,'validation', '');
            $req            = UniteFunctionsForms::getVal($setting,'Required', 'false');
            $text           = UniteFunctionsForms::getVal($setting,'text', 'a field');
            $recommended    = UniteFunctionsForms::getVal($setting,'Required', 'false');

			$className = "";
			if(isset($this->arrControls[$setting["name"]])) $className = "control";
			$class = "";
			if($className != "") $class = $className;

			$class .= " form-control";

			$disabled = "";
			if(isset($setting["disabled"])) $disabled = 'disabled="disabled"';
			
			$settingValue = $setting["value"];
			$ngModelAttr = "";
			if(!is_null($setting['ngModel'])){
				$ngModelAttr = "ng-model=\"" . $setting['ngModel'] . "\"";
			}
			?>
			<label class="select-customisized">
			<select id="<?php echo $setting["id"]?>"
					<?php echo $ngModelAttr?>
                    name="<?php echo $setting["name"]?>"
                    data-required="<?php echo $req;?>"
                    data-validation="<?php echo $validation;?>"
                    data-title="<?php echo $text;?>"
                    data-value="<?php echo $settingValue?>"
                    data-recommended="<?php echo $recommended?>"
                <?php echo $disabled?> class="<?php echo $class?>" >
			<?php			
			foreach($setting["items"] as $item):
				$selected = "";
				if($item['value'] == $setting["value"]) $selected = 'selected="selected"';
				?>
					<option value="<?php echo $item['value']?>" <?php echo $selected?>><?php echo $item['text']?></option>
				<?php
			endforeach
			?>
			</select></label>
			<?php
		}
		
		
		//-----------------------------------------------------------------------------------------------
		//draw hr row
		public function drawTextRow($setting){
			
			//set cell style
			$cellStyle = "";
			if(isset($setting["padding"])) 
				$cellStyle .= "padding-left:".$setting["padding"].";";
				
			if(!empty($cellStyle))
				$cellStyle="style='$cellStyle'";
				
			//set style
			$rowStyle = "";					
			if(isset($setting["hidden"])) 
				$rowStyle .= "display:none;";
				
			if(!empty($rowStyle))
				$rowStyle = "style='$rowStyle'";
			
			?>
				<div id="<?php echo $setting["id_row"]?>" <?php echo $rowStyle ?> valign="top">
					<span <?php echo $cellStyle?>>
						<span class="spanSettingsStaticText"><?php echo $setting["text"]?></span>
					</span>
				</div>
			<?php 
		}
		
		//-----------------------------------------------------------------------------------------------
		//draw hr row
		public function drawHrRow($setting){
			//set hidden
			$rowStyle = "";
			if(isset($setting["hidden"])) $rowStyle = "style='display:none;'";
			
			$class = UniteFunctionsForms::getVal($setting, "class");
			if(!empty($class))
				$class = "class='$class'";
			
			?>
			<div id="<?php echo $setting["id_row"]?>" <?php echo $rowStyle ?>>
				<span colspan="4" align="left" style="text-align:left;">
					 <hr <?php echo $class; ?> />
				</span>
			</div>
			<?php 
		}
		
		
		/**
		 * draw settings row
		 */
		public function drawSettingRow($setting){
			$required = UniteFunctionsForms::getVal($setting, "required");
            $recommended = UniteFunctionsForms::getVal($setting, "recommanded");
			//set cellstyle:
			$cellStyle = "";
			if(isset($setting[UniteSettingsForms::PARAM_CELLSTYLE])){
				$cellStyle .= $setting[UniteSettingsForms::PARAM_CELLSTYLE];
			}
			
			//set text style:
			$textStyle = $cellStyle;
			if(isset($setting[UniteSettingsForms::PARAM_TEXTSTYLE])){
				$textStyle .= $setting[UniteSettingsForms::PARAM_TEXTSTYLE];
			}
			
			if($textStyle != "") $textStyle = "style='".$textStyle."'";
			if($cellStyle != "") $cellStyle = "style='".$cellStyle."'";
			
			//set hidden
			$rowStyle = "";
			if(isset($setting["hidden"])) $rowStyle = "display:none;";
			if(!empty($rowStyle)) $rowStyle = "style='$rowStyle'";
			
			//set text class:
			$class = 'class="setting-wrap full form-group';
			if(isset($setting["disabled"])) $class .= " disabled ";
			if(!empty($required)) $class .= " required ";
			if(!empty($recommended) && empty($required) ) $class .= " recommended ";
            $class .= '"';
			
			//modify text:
			$text = UniteFunctionsForms::getVal($setting,"text","");				
			// prevent line break (convert spaces to nbsp)
			$text = str_replace(" ","&nbsp;",$text);
			switch($setting["type"]){					
				case UniteSettingsForms::TYPE_CHECKBOX:
					$text = "<label for='".$setting["id"]."' style='cursor:pointer;'>$text</label>";
				break;
			}			
			
			//set settings text width:
			$textWidth = "";
			if(isset($setting["textWidth"])) $textWidth = 'width="'.$setting["textWidth"].'"';
			
			$description = UniteFunctionsForms::getVal($setting, "description");

			?>

				<div id="<?php echo $setting["id_row"]?>" <?php echo $rowStyle ?> <?php echo $class;?> valign="top">
					<label class="col-sm-4 control-label" <?php echo $textStyle?>  <?php echo $textWidth ?>>
					<?php echo( trim( str_replace('&nbsp;', ' ', $text) ) );?>:
					</label>
					<span class="col-sm-8" <?php echo $cellStyle?>>
						<?php 
							$this->drawInputs($setting);
						?>
                        <?php if(!empty($description)):?>
							<span class="help-block"><?php echo $description?></span>
						<?php endif?>						
					</span>
				</div>
			<?php 
		}
		
		
		/**
		 * 
		 * draw setting input by name
		* @param $name
		* @param null $ngModel
		* @throws Exception
		*/
		public function drawSetting($name, $ngModel = null){
			$setting = $this->settings->getSettingByName($name);
			$setting['ngModel'] = $ngModel;
			$this->drawInputs($setting);

		}
		
		
		/**
		 * 
		 * draw setting title
		 */
		public function drawSettingTitle($name){
			//$settings = new UniteSettingsForms();
			$setting = $this->settings->getSettingByName($name);
			$text = UniteFunctionsForms::getVal($setting, "text");
			?>
                <label for="<?php echo $setting["id"]?>">
                  <?php echo $text?>:
                </label>
			<?php 			
		}
			
		/**
		 *
		 * insert settings into saps array
		 */
		private function groupSettingsIntoSaps(){
			$arrSections = $this->settings->getArrSections();
			$arrSaps = $arrSections[0]["arrSaps"];
			$arrSettings = $this->settings->getArrSettings();
			
			
			//group settings by saps
			foreach($arrSettings as $key=>$setting){
		
				$sapID = $setting["sap"];
		
				if(isset($arrSaps[$sapID]["settings"]))
					$arrSaps[$sapID]["settings"][] = $setting;
				else
					$arrSaps[$sapID]["settings"] = array($setting);
			}
			return($arrSaps);
		}
		
		
		/**
		 * draw all settings
		 */
		public function drawSettings($formName){
			
			//$this->drawHeaderIncludes();
			//$this->prepareToDraw();
			
			$arrSaps = $this->groupSettingsIntoSaps();
			
			?>
				<form name="<?php echo $formName?>" novalidate>
			<?php 
			/*
			$class = "unite-postbox";
			if(!empty($this->addClass))
				$class .= " ".$this->addClass;
			
			//draw wrapper
			echo "<div class='settings_wrapper'>";
				
			//draw settings - advanced - with sections
			foreach($arrSaps as $key=>$sap):

				//set accordion closed
				$style = "";
				if($this->isAccordion == false){
					$h3Class = " no-accordion";
				}else{
					$h3Class = "";
					if($key>0){
						$style = "style='display:none;'";
						$h3Class = " box_closed";
					}
				}
					
				$text = $sap["text"];
				$classIcon = UniteFunctionsUC::getVal($sap, "icon");
				$text = __($text,UNITECREATOR_TEXTDOMAIN);
				
				?>
					<div class="<?php echo $class?>">
						<div class="unite-postbox-title<?php echo $h3Class?>">
						
						<?php if(!empty($classIcon)):?>
						<i style="float:left;margin-top:4px;font-size:14px;" class="<?php echo $classIcon?>"></i>
						<?php endif?>
						
						<?php if($this->isAccordion == true):?>
							<div class="unite-postbox-arrow"></div>
						<?php endif?>
						
							<span><?php echo $text ?></span>
						</div>			
												
						<div class="inside" <?php echo $style?> >
							<ul class="list_settings">
						<?php
							
							$settings = UniteFunctionsUC::getVal($sap, "settings", array());
								
							foreach($settings as $setting)
								$this->drawSetting($setting);
							
							?>
							</ul>
							
							<?php 
							if(!empty($this->arrButtons)){
								?>
								<div class="unite-clear"></div>
								<div class="settings_buttons">
								<?php 
									$this->drawButtons();
								?>
								</div>	
								<div class="unite-clear"></div>
								<?php 								
							}								
						?>
						
							<div class="unite-clear"></div>
						</div>
					</div>
				<?php 			
														
			endforeach;
			
			echo "</div>";	//wrapper close
				*/		
			?>
			</form>
			<?php 
		}
		
		
		//-----------------------------------------------------------------------------------------------
		// draw sections menu
		public function drawSections($activeSection=0){
			if(!empty($this->arrSections)):
				echo "<ul class='listSections' >";
				for($i=0;$i<count($this->arrSections);$i++):
					$class = "";
					if($activeSection == $i) $class="class='selected'";
					$text = $this->arrSections[$i]["text"];
					echo '<li '.$class.'><a onfocus="this.blur()" href="#'.($i+1).'"><div>'.$text.'</div></a></li>';
				endfor;
				echo "</ul>";
			endif;
				
			//call custom draw function:
			if($this->customFunction_afterSections) call_user_func($this->customFunction_afterSections);
		}
		

		
	}
?>