<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class HelperUF{
	
	private static $frontScriptsPutOnce = false;
	
	
	/**
	 * put front scripts
	 */
	public static function putFrontScripts(){
		
		if(self::$frontScriptsPutOnce == true)
			return(false);
		
		self::$frontScriptsPutOnce = true;
		

		ProviderFunctionsUF::putFrontJqueryInclude();
		
		$urlAssets = GlobalsUniteForms::$urlAssetsMedia;
		
		ProviderFunctionsUF::addScriptAbsoluteUrl("unite-forms-plugin-js", $urlAssets."uf-plugin/unite-forms.js");
		ProviderFunctionsUF::addStyleAbsoluteUrl("unite-forms-plugin-css", $urlAssets."uf-plugin/unite-forms.css");
		
	}
	
	
	/**
	 * output form by id or alias
	 */
	public static function outputForm($formID, $outputBy="id"){
		try{
			
			UniteFunctionsForms::validateNotEmpty($formID, "form id");
			
			self::putFrontScripts();
			
			$operations = new UniteFormsOperations();
			
			$form = new UniteFormsForm();
			if($outputBy == "alias")
				$form->initByAlias($formID);
			else
				$form->initByID($formID);
			
			$formID = $form->getID();
			
			//load params
			$arrValues = $form->getParams();
			$form_params = $operations->getCombinedSettingsForm($arrValues);
			
			$arrFields = $form->getArrFields();
			
			//make output:
			$output = new UniteFormsOutput();
			$output->init($formID, $form_params, $arrFields);
			
			$output->outputForm();
			
		}catch(Exception $e){
			
			$message = "Unite Forms Error: ".$e->getMessage();
			$htmlError = HelperUF::getErrorMessageHtml($message);
			echo $htmlError;
		}
		
	}
	
	
	/**
	 * get error message html
	 */
	public static function getErrorMessageHtml($message, $trace = ""){
	
		$html = '<div style="width:100%;min-width:400px;height:300px;margin-bottom:10px;border:1px solid black;margin:0px auto;overflow:auto;">';
		$html .= '<div style="padding-left:20px;padding-right:20px;line-height:1.5;padding-top:40px;color:red;font-size:16px;text-align:left;">';
		$html .= $message;
	
		if(!empty($trace)){
			$html .= '<div style="text-align:left;padding-left:20px;padding-top:20px;">';
			$html .= "<pre>{$trace}</pre>";
			$html .= "</div>";
		}
	
		$html .= '</div></div>';
	
		return($html);
	}
	
	
	
}

?>