<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class UniteFormsOperations extends UniteFormsBase {
	
    /**
     * 
     * init the form, set fields and send the form
     */
    public function sendFormFromData($data, $previewMode=false) {

        $formID = UniteFunctionsForms::getVal($data, "formID");
        $arrValues = UniteFunctionsForms::getVal($data, "fields");
		
        $form = new UniteFormsForm();
        $form->initByID($formID);
        $form->setFieldValues($arrValues);
        $form->validateForm();  
        $form->saveRecord();
        $form->sendToAdmin($previewMode);
        
        //prepare output variables
        $output = array();
        $output["redirect_link"] = $form->getParamRedirectAfterSend();
        
        return($output);
    }

    
    /**
     * 
     * convert input from js to name/value options
     */
    public function convertInputToNameValue($arrInput) {
        $arrOutput = array();
        foreach ($arrInput as $option) {
            $value = UniteFunctionsForms::getVal($option, "value");
            $name = UniteFunctionsForms::getVal($option, "name");
            $arrOutput[$name] = $value;
        }

        return($arrOutput);
    }


    /**
     * 
     * get list of forms
     */
    public function getArrForms() {

        $arrForms = $this->db->fetch(GlobalsUniteForms::$table_forms);

        $arrOutput = array();
        foreach ($arrForms as $record) {
            $form = new UniteFormsForm();
            $form->initFromDBRecord($record);
            $arrOutput[] = $form;
        }

        return($arrOutput);
    }

    /**
      /* search some form with some title
     */
    public function getArrFormTitles() {
        $response = $this->db->fetch(GlobalsUniteForms::$table_forms);
        $arrTitles = array();

        foreach ($response as $record) {
            $arrTitles[] = $record["title"];
        }

        return($arrTitles);
    }

    /**
     *
     * get all default values together with form values
     * @param $arrValues
     * @return array
     */
    public function getCombinedSettingsForm($arrValues) {
	
        $currentDir = dirname(__FILE__);
        $pathSettings = $currentDir.'/../settings/';
        $settingsGeneral = new UniteSettingsForms();
                
        $settingsGeneral->loadXMLFile($pathSettings . "general.xml", "general");
				
        $settingsOptions = new UniteSettingsForms();
        $settingsOptions->loadXMLFile($pathSettings. "form_options.xml", "options");
//dmp($arrValues);exit;
        if (!empty($arrValues)) {
            $settingsGeneral->setStoredValues($arrValues);
            $settingsOptions->setStoredValues($arrValues);
        }

        $paramsGeneral = $settingsGeneral->getArrValues();

        $paramsOptions = $settingsOptions->getArrValues();

        $params = array_merge($paramsGeneral, $paramsOptions);

        return($params);
    }

    /**
     *
     * get captcha url according some width and height
     * @param $width
     * @param $height
     * @return mixed
     */
    public function getUrlCaptcha($width, $height){
    	$url = GlobalsUniteForms::$urlCapcha."&w={$width}&h={$height}";
    	
    	$url = UniteFunctionsForms::urlEncode($url);
    	
    	return($url);
    }

    
    /**
     * 
     * show captcha image
     */
    public function showCaptchaImage($width = 300, $height = 100){
    	$img = new Securimage();
    	
    	if(!empty($width))
    		$img->image_width = $width;
    	
    	if(!empty($height))
    		$img->image_height = $height;
    	
    	$img->show();
    	exit();
    }
    
    
    /**
     * validate the captcha
     */
    public function checkCaptcha($value){
    	$objCaptcha = new Securimage();
    	$isCorrect = $objCaptcha->check($value);
    	return($isCorrect);
    }
    
}

?>