<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class UniteFormsTemplates extends UniteFormBaseClass{
	
	const TEMPLATE_TYPE_STYLE = "style";
	const TEMPLATE_TYPE_FIELDS = "fields";
	
	private static $arrTemplatesStyles;
	private static $arrTemplatesFields;
	
	
	/**
	 * 
	 * constructor
	 */
	public function __construct(){
		parent::__construct();
	}

	/**
	 * 
	 * valiadte templates type
	 */
	private function validateType($type){
		
		switch ($type){
			case self::TEMPLATE_TYPE_FIELDS:
			case self::TEMPLATE_TYPE_STYLE:
			break;
			default:
				UniteFunctionsForms::throwError("wrong type: {$type}");
			break;
		}
		
	}
	
	/**
	 * 
	 * validate if exists some template with given alias
	 */
	private function validateAliasExists($alias, $type){
		
		$arrTemplates = $this->getArrTemplates($type);
		$template = UniteFunctionsForms::getVal($arrTemplates, $alias);
		 
		if(!empty($template))
			UniteFunctionsForms::throwError("template with alias: {$alias} already exists");		
	}
	
	/**
	 * 
	 * get template filepath by alias and type
	 */
	private function getFilepath($alias,$type){
		
		//get filepath path
		switch($type){
			case self::TEMPLATE_TYPE_FIELDS:
				$pathFile = GlobalsUniteForms::$pathTemplatesFields.$alias.".json";
			break;
			case self::TEMPLATE_TYPE_STYLE:
				$pathFile = GlobalsUniteForms::$pathTemplatesStyle.$alias.".json";
			break;
			default:
				UniteFunctionsForms::throwError("wrong template type: $type");
			break;
		}
		
		return($pathFile);
	}
	
	
	/**
	 * 
	 * create template from data
	 */
	public function createTemplateFromData($data){
		$title = UniteFunctionsForms::getVal($data, "name");
		$alias = UniteFunctionsForms::getVal($data, "alias");
		$styles = UniteFunctionsForms::getVal($data, "styles");
		$type = UniteFunctionsForms::getVal($data, "type");

		//validation
		$this->validateType($type);
		$this->validateAliasExists($alias, $type);
				
		//get data from form
		$arrData["title"] = $title;
		$arrData["alias"] = $alias;
		$arrData["params"] = $styles;

		$strData = json_encode($arrData);
		
		$pathFile = $this->getFilepath($alias, $type);
		
		UniteFunctionsForms::writeFile($strData, $pathFile);
				
	}
	
	
	
	/**
	 * 
	 * get path of templates folder by type
	 */
	private function getPathByType($type){
		$this->validateType($type);
		if($type == self::TEMPLATE_TYPE_FIELDS)
			$path = GlobalsUniteForms::$pathTemplatesFields;
		else
			$path = GlobalsUniteForms::$pathTemplatesStyle;
		
		return($path);
	}
	
	/**
	 * 
	 * get template array from file
	 */
	private function getArrTemplateFromFile($filepath){
		
		$info = pathinfo($filepath);
		$filename = $info["basename"];
		
		UniteFunctionsForms::validateFilepath($filepath, "file template");
		$content = file_get_contents($filepath);
		$arr = @json_decode($content);
		
		if(empty($arr))
			UniteFunctionsForms::throwError("wrong template format: $filepath");
			
		//convert to array
		$arr = UniteFunctionsForms::convertStdClassToArray($arr);
		$data = UniteFunctionsForms::getVal($arr, "data"); 
		$arr["data"] = UniteFunctionsForms::convertStdClassToArray($data);
		
		$arr["filename"] = $filename;
		
		return($arr);		
	}


	/**
	 *
	 * get params merged with settings output (general settings);
	 * @param $arrParams
	 * @return array
	 */
	private function modifyParamsBySettingsObject($arrParams){
		
    	$settings = new UniteSettingsForms();
        $settings->loadXMLFile(GlobalsUniteForms::$pathSettings."general.xml", "general");
        $settings->setStoredValues($arrParams);
		$arrParams = $settings->getArrValues();
		
		return($arrParams);
	}
	
	
	/**
	 * 
	 * get templates array
	 */
	public function getArrTemplates($type){
		
		if($type == self::TEMPLATE_TYPE_FIELDS)
			$arrExisting = self::$arrTemplatesFields;
		else
			$arrExisting = self::$arrTemplatesStyles;
		
		if(!empty($arrExisting))
			return($arrExisting);
		
		$path = $this->getPathByType($type);
		
		$arrFiles = UniteFunctionsForms::getFileList($path);
		
		$arrTemplates = array();
		foreach($arrFiles as $file){
			$filepathTemplate = $path.$file;
			$arrTemplate = $this->getArrTemplateFromFile($filepathTemplate);
			$arrTemplate["params"] = $this->modifyParamsBySettingsObject($arrTemplate["params"]);
			$alias = UniteFunctionsForms::getVal($arrTemplate, "alias");
			$arrTemplates[$alias] = $arrTemplate;
		}

		
		if($type == self::TEMPLATE_TYPE_FIELDS)
			self::$arrTemplatesFields = $arrTemplates;
		else
			self::$arrTemplatesStyles = $arrTemplates;
		
		return($arrTemplates);
	}
	
	/**
	 * 
	 * get json template with fields accordign to type.
	 */
	public function getJsonTemplates($type){
		$arrTemplates = $this->getArrTemplates($type);
		
		if(empty($arrTemplates))
			return("{}");
		
		$arrFormsNew = array();
		foreach($arrTemplates as $alias => $template){
			$arr = array();
			$arr["title"] = UniteFunctionsForms::getVal($template, "title");
						
			switch($type){
				case self::TEMPLATE_TYPE_FIELDS:
					$arr["fields"] = UniteFunctionsForms::getVal($template, "data");
				break;
				case self::TEMPLATE_TYPE_STYLE:
					$arr["params"] = UniteFunctionsForms::getVal($template, "params");
				break;
				default:
					UniteFunctions::throwError("wrong type: $type");
				break;
			}
			$arrFormsNew[$alias] = $arr;
		}
		
		$jsonOutput = UniteFunctionsForms::jsonEncodeForClientSide($arrFormsNew);
		
		return($jsonOutput);
	}
	
	
	/**
	 * 
	 * get short array of templates
	 */
	public function getArrTemplatesShort($type, $addEmpty = false){
				
		$arrTemplates = $this->getArrTemplates($type);
		
		$arrNew = array();
		if($addEmpty == true)
			$arrNew["not_selected"] = "Not Selected";
			
		foreach($arrTemplates as $alias=>$template){
			$title = UniteFunctionsForms::getVal($template, "title");
			$arrNew[$alias] = $title; 
		}
		
		return($arrNew);
	}
	
	
	/**
	 * 
	 * delete template
	 */
	private function deleteTemplate($type, $alias){
		
		$filepath = $this->getFilepath($alias, $type);
		UniteFunctionsForms::validateFilepath($filepath,"template file");
		$success = @unlink($filepath);
		
		if(empty($success))
			UniteFunctionsForms::throwError("Can't delete file: $filepath");
	}
	
	
	/**
	 * 
	 * delete template by data
	 */
	public function deleteTemplateByData($data){
		
		$type = UniteFunctionsForms::getVal($data, "type");
		$alias = UniteFunctionsForms::getVal($data, "alias");
		
		UniteFunctionsForms::validateNotEmpty($type, "type");
		UniteFunctionsForms::validateNotEmpty($alias, "alias");
		
		$this->deleteTemplate($type, $alias);
	}
	
	
}

?>