<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class com_uniteformInstallerScript
{
	
	/**
	 * Constructor
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
	public function __constructor(JAdapterInstance $adapter){
		
	}
 
	/**
	 * Called before any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function preflight($route, JAdapterInstance $adapter){
		
	}
 
	/**
	 * Called after any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function postflight($route, JAdapterInstance $adapter){
		
	}
 	
	/**
	 * 
	 * install the modules from "modules" folder
	 */
	public function installModules(JAdapterInstance &$adapter,$type="install"){
		
		$ds = "";
		if(defined("DIRECTORY_SEPARATOR"))
			$ds = DIRECTORY_SEPARATOR;
		else
			$ds = DS;
		
		$manifest = $adapter->get("manifest");
		
		$installer = new JInstaller();
		$p_installer = $adapter->getParent();
		
		
		// Install modules
		if (is_object($manifest->modules->module)){	
			foreach($manifest->modules->module as $module){
				$attributes = $module->attributes();
				$modulePath = $p_installer->getPath("source") . $ds . $attributes['folder'] . $ds . $attributes['module'];
				
				if($type == "install")
					$installer->install($modulePath);
				else 
					$installer->update($modulePath);
			}
		}
		
	}
	
	/**
	 * 
	 * install the plugins from "plugins" folder
	 */
	public function installPlugins(JAdapterInstance &$adapter,$type="install"){
		
		$ds = "";
		if(defined("DIRECTORY_SEPARATOR"))
			$ds = DIRECTORY_SEPARATOR;
		else
			$ds = DS;
		
		$manifest = $adapter->get("manifest");
		
		$installer = new JInstaller();
		$p_installer = $adapter->getParent();
		
		// Install plugins
		if (is_object($manifest->plugins->plugins)){	
			foreach($manifest->plugins->plugin as $plugin){
				$attributes = $plugin->attributes();
				$pluginPath = $p_installer->getPath("source") . $ds . $attributes['folder'] . $ds . $attributes['plugin'];
				
				$isExists = true;
				if($type != "install"){
					$pluginName = $attributes['plugin'];
					$isExists = $this->isPluginExists($pluginName);
				}
				
				if($type == "install" || $isExists = false)
					$installer->install($pluginPath);
				else 
					$installer->update($pluginPath);
			}
		}
		
	}
	
	/**
	 * is plugin exists
	 */
	private function isPluginExists($name){
		
		$db = JFactory::getDbo();
		$query = "SELECT enabled FROM #__extensions WHERE element = '{$name}' and type='plugin'";
		$db->setQuery($query);
		$response = $db->loadResult();
		
		//print_r($response);print_r($query);exit();
		
		return(!empty($response));
	}

	/**
	 * publish the plugin
	 */
	private function publishPlugin(){
		
		$sql = "UPDATE `#__extensions` SET `enabled`=1 where (`type`=\"plugin\" and `element`=\"uniteform\")";
		
		$db = JFactory::getDbo();
		$db->setQuery($sql);
		$db->query();
	}
	
	
	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install(JAdapterInstance $adapter){
		
		$this->installModules($adapter,"install");
		$this->installPlugins($adapter,"install");
		$this->publishPlugin();		
	}
 
	
	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function update(JAdapterInstance $adapter){
		
		$this->installModules($adapter,"update");
		$this->installPlugins($adapter,"update");
		$this->publishPlugin();
	}

	
	/**
	 * Called on uninstallation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
	public function uninstall(JAdapterInstance $adapter){
		
	}
}

?>