<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;




class UniteFunctionJoomlaForm {

    private static $arrControls;
    public static $componentName = 'com_uniteform'; //current component name. have to be set on include.
    public static $app;

    /**
     * 
     * return if current joomla version is joomla 3
     */
    public static function isJoomla3() {

        if (defined("JVERSION")) {
            $version = JVERSION;
            $version = (int) $version;
            return($version == 3);
        }

        if (class_exists("JVersion")) {
            $jversion = new JVersion;
            $version = $jversion->getShortVersion();
            $version = (int) $version;
            return($version == 3);
        }

        return(!defined("DS"));
    }

    /**
     * 
     * add script wrapper
     */
    public static function addScript($urlScript) {
        $document = JFactory::getDocument();
        $document->addScript($urlScript);
    }

    /**
     * 
     * add style wrapper
     */
    public static function addStyle($urlStyle, $id = null) {
        $document = JFactory::getDocument();
        $attribs = array();
        if (!empty($id))
            $attribs["id"] = $id;

        $document->addStyleSheet($urlStyle, "text/css", null, $attribs);
    }

    /**
     * 
     * encode array to registry (json) for saving, in some array of items
     * 
     */
    public static function encodeArrayToRegistry($arr, $field) {

        if (!isset($arr[$field]))
            return("");

        if (!is_array($arr[$field]))
            return($arr[$field]);

        $registry = new JRegistry();
        $registry->loadArray($arr[$field]);
        $value = $registry->toString('JSON');

        return($value);
    }

    /**
     * 
     * decode some array item to registry
     */
    public static function decodeRegistryToArray($arr, $field) {

        $output = array();
        if (!isset($arr[$field]))
            return($output);

        $value = $arr[$field];
        if (is_array($value))
            return($value);

        $registry = new JRegistry();
        $registry->loadString($value, 'JSON');
        $output = $registry->toArray();

        return($output);
    }


    /**
     * 
     * get component url - site side
     * 
     */
    public static function getUrlComponent($args, $component = "") {
        if (empty($component))
            $component = self::$componentName;
        $url = juri::root() . "index.php?option=" . $component . "&" . $args;

        return($url);
    }


    /**
     * get cache path. if not exists - try to crate it
     */
    private static function getPathCache() {

        //set cache path
        $component = self::$componentName;

        $pathCache = JPATH_SITE . "/cache/" . $component . "/";
        if (is_dir($pathCache))
            return($pathCache);

        @mkdir($pathCache);

        if (is_dir($pathCache))
            return($pathCache);

        //make media cache path
        $pathCache = JPATH_SITE . "/media/" . $component . "/cache/";
        if (is_dir($pathCache))
            return($pathCache);

        @mkdir($pathCache);

        if (is_dir($pathCache))
            return($pathCache);

        //make component cache path
        $pathCache = JPATH_COMPONENT_SITE . "/cache/";

        return($pathCache);
    }

    /**
     * 
     * get post or get application
     */
    public static function getPostGetVar($name, $default = "", $filter = "STRING") {
        if (empty(self::$app))
            self::$app = JFactory::getApplication();

        $jinput = self::$app->input;
        $var = $jinput->get($name, $default, $filter);
        return($var);
    }

    /**
     * 
     * check if jquery script included
     */
    public static function isJqueryIncluded() {
        $document = JFactory::getDocument();
        $arrScripts = $document->_scripts;
        foreach ($arrScripts as $filepath => $arrDetails) {
            $filename = basename($filepath);
            $filename = strtolower($filename);
            switch ($filename) {
                case "jquery.min.js":
                    return(true);
                    break;
            }
        }
        return(false);
    }

}

?>