<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class ProviderFunctionsUF{
	
	
	/**
	 * init base variables of the globals
	 */
	public static function initGlobalsBase(){
		
		$isAdmin = self::isAdmin();
		
		$componentName = "com_uniteform";
		
		GlobalsUniteForms::$extensionName = "uniteform";
		
		$tablePrefix = "#__";
		GlobalsUniteForms::$table_forms = $tablePrefix."uniteforms";
		
		$currentDir = dirname(__FILE__);
		GlobalsUniteForms::$pathBase = realpath($currentDir . "/../") . "/";
		
		GlobalsUniteForms::$urlRoot = JURI::root();
		
		if(self::isSSL() == true)
			GlobalsUniteForms::$urlRoot = str_replace("http://", "https://", GlobalsUniteForms::$urlRoot);
		
		GlobalsUniteForms::$urlBase = GlobalsUniteForms::$urlRoot."administrator/components/{$componentName}/";
		
		if($isAdmin == true){
			GlobalsUniteForms::$urlComponent = GlobalsUniteForms::$urlRoot."administrator/index.php?option={$componentName}";
			GlobalsUniteForms::$urlAjax = GlobalsUniteForms::$urlRoot."administrator/index.php?option={$componentName}&view=form&layout=ajax";
		}else{
			GlobalsUniteForms::$urlComponent = GlobalsUniteForms::$urlRoot."index.php?option={$componentName}";
			GlobalsUniteForms::$urlAjax = GlobalsUniteForms::$urlRoot."index.php?option={$componentName}&view=form&layout=ajax";
		}
		
		GlobalsUniteForms::$urlAjaxFront = GlobalsUniteForms::$urlRoot."index.php?option={$componentName}&view=form&layout=ajax";
		
		GlobalsUniteForms::$urlAssetsMedia = GlobalsUniteForms::$urlRoot . "media/{$componentName}/assets/";
		GlobalsUniteForms::$urlCapcha = GlobalsUniteForms::$urlRoot."index.php?option={$componentName}&action=showcapcha";
		
	}
	
	
	/**
	 * add script, relative to assets/js path
	 */
	public static function addScript($handle, $urlScript){
		
		if(empty($urlScript))
			UniteFunctionsForms::throwError("The script could not be empty, handle: {$handle}");
		
		$urlScript = GlobalsUniteForms::$urlAssets.$urlScript;
		
		self::addScriptAbsoluteUrl($handle, $urlScript);
	}
	
	
	/**
	 * add script absolute url
	 */
	public static function addScriptAbsoluteUrl($handle, $urlScript){
		
		if(empty($handle))
			UniteFunctionsForms::throwError("The handle shoud be given for: {$urlScript}");
		
		if(empty($urlScript))
			UniteFunctionsForms::throwError("The script could not be empty for handle: $handle");
			
		$document = JFactory::getDocument();
		$document->addScript($urlScript);
	}

	
	/**
	 * add script, relative to assets/js path
	 */
	public static function addStyle($handle, $urlStyle){
	
		if(empty($urlStyle))
			UniteFunctionsForms::throwError("The style could not be empty, handle: {$handle}");
	
		$urlStyle = GlobalsUniteForms::$urlAssets.$urlStyle;
	
		self::addStyleAbsoluteUrl($handle, $urlStyle);
	}
	
	
	/**
	 * add style absolute url
	 */
	public static function addStyleAbsoluteUrl($handle, $urlStyle){
		
		if(empty($handle))
			UniteFunctionsForms::throwError("The handle shoud be given for: {$urlStyle}");
		
		if(empty($urlStyle))
			UniteFunctionsForms::throwError("The style could not be empty for handle: {$handle}");
		
		$document = JFactory::getDocument();
		$document->addStyleSheet($urlStyle);
	}
	
	
	/**
	 * add admin framework
	 */
	public static function addAdminFramework(){
		$isJoomla3 = UniteFunctionJoomlaForm::isJoomla3();
		
		if ($isJoomla3) {
			JHtml::_('bootstrap.framework');
		}else{
			self::addScript("jquery", "js/vendor/jquery-1.11.3.min.js");
		}
		
	}
	
	/**
	 * put front end jquery include
	 */
	public static function putFrontJqueryInclude(){
		$isJoomla3 = UniteFunctionJoomlaForm::isJoomla3();
		
		if ($isJoomla3) {
			JHtml::_('bootstrap.framework');
		}else{
			self::addScript("jquery", "js/vendor/jquery-1.11.3.min.js");
		}
	}
	
	
	
	/**
	 * add inline script
	 */
	public static function addScriptInline($script){
		$document = JFactory::getDocument();
		$document->addScriptDeclaration($script);		
	}
	
	
	
	/**
	 * is ssl
	 */
	public static function isSSL(){
		return JURI::getInstance()->isSSL();
	}
	
	
	/**
	 * is admin
	 */
	public static function isAdmin(){
		$app = JFactory::getApplication();
		
		$isAdmin = $app->isAdmin();
		
		return($isAdmin);
	}
	
	
	
}
