<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;

class UniteFormsAdmin extends UniteFormBaseClass{
	
	protected static $master_view;
	public static $view;
	public static $layout;
	private static $tempVars = array();
	private static $title;
	
	
	/**
	 * validate inited
	 */
	private static function validateInited(){
		if(empty(self::$view))
			UniteFunctionsForms::throwError("The form admin is not inited");
	}
	
	
	/**
	 *
	 * set the view from GET variables
	 */
	public static function init(){
		
		//set title
		
		self::$title = GlobalsUniteForms::TITLE;
		
		//set view
		$defaultView = GlobalsUniteForms::VIEW_DEFAULT;
		
		//set view
		$viewInput = UniteFunctionsForms::getGetVar("view");
		$page = UniteFunctionsForms::getGetVar("page");
	
		//get the view out of the page
		if(strpos($page,"_") !== false){
			$parts = explode("_", $page);
			$view = $parts[1];
		}
		
		if(!empty($viewInput))
			$view = $viewInput;
	
		if(empty($view)){
			$view = $defaultView;
		}

		self::$view = $view;
		
		//set layout
		self::$layout = UniteFunctionsForms::getPostGetVar("layout");
	}

	
	/**
	 *
	 * set view that will be the master
	 */
	protected static function setMasterView($masterView){
		self::$master_view = $masterView;
	}
	
	
	/**
	 *
	 * inlcude some view file
	 */
	protected static function requireView($view){
		
		self::validateInited();
		
		try{
	
	
			//require master view file, and
			if(!empty(self::$master_view) && !isset(self::$tempVars["is_masterView"]) ){
				$masterViewFilepath = GlobalsUniteForms::$pathViews.self::$master_view.".php";
				
				UniteFunctionsForms::validateFilepath($masterViewFilepath, "Master View");
				
				self::$tempVars["is_masterView"] = true;
	
				require $masterViewFilepath;
	
			}
			else{		//simple require the view file.
				$viewFilepath = GlobalsUniteForms::$pathViews.$view.".php";
	
				UniteFunctionsForms::validateFilepath($viewFilepath,"View");
				require $viewFilepath;
			}
	
		}catch (Exception $e){
			echo "<br><br>View ($view) Error: <b>".$e->getMessage()."</b>";
			
			if(GlobalsUniteForms::SHOW_TRACE == true)
				dmp($e->getTraceAsString());
		}
	}
	
	
	/**
	 * add scripts to normal pages
	 */
	public static function addScripts(){
		self::validateInited();
		HelperBackendUF::putAdminIncludes();
	}
	
	
	/**
	 * check ajax actions
	 */
	public static function checkAjaxActions(){
		
		if(self::$layout != "ajax")
			return(false);
		
		$actions = new UniteFormsActions();
		$isAdmin = ProviderFunctionsUF::isAdmin();
		
		if($isAdmin)
			$actions->operate();
		else
			$actions->operateFront();
		exit();
		
	}

	
	/**
	 *
	 * admin main page function.
	 */
	public static function adminPages($addScripts = false){
		
		self::validateInited();
		
		self::checkAjaxActions();
		
		self::setMasterView("master_view");
		self::requireView(self::$view);
	
	}
	
	
	/**
	 * set title suffix
	 */
	public static function setTitleSuffix($suffix){
		self::$title = GlobalsUniteForms::TITLE." - ".$suffix;
	}
	
	
	/**
	 * get title
	 */
	public static function getTitle(){
		
		return(self::$title);
	}
	
	
}