<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class UniteFormsEditFormView{

	protected $isAdmin = true;
	protected $isDemoMode = false;
	protected $linkBuyNow = "http://unitecms.net/cart?productid=31";
	
    protected $form;
    protected $formID;
    protected $state;
    protected $params;
    protected $isEmpty = true;
    protected $o, $o2;
	protected $jsonTemplateStyles;
	protected $jsonTemplateFields;
	protected $jsonGeneralSettings;
	protected $jsonOptionsSettings;
    
	
    /**
     * print settings diff
     */
    private function printSettingsDiff($arrOriginal, $arrSettings){
    	
    	//dmp($arrOriginal);exit();
    	
    	$diff = UniteFunctionsForms::getArrayDiff($arrOriginal, $arrSettings);
    	
    	dmp($diff);
    	exit();
    }

    /**
     * 
     * prepare visual view parameters
     */
    private function prepareVisualView($formID){

        /* add stuff to doc */
        $urlAssets = GlobalsUniteForms::$urlAssets;

        
    	/* init values */
        $this->form = new UniteFormsForm();
        $this->form->initByID($formID);
        
        if($this->isDemoMode == true){
        	
        	$alias = $this->form->getAlias();
        	if($alias != "demo"){
        		UniteFunctionsForms::throwError("Form with id: {$formID} not found.");
        		exit();
        	}
        }
        
        $this->formID = $this->form->getID();
        
        $templates = new UniteFormsTemplates();   	    
    	$settingsGeneral = new UniteSettingsForms();
    	$settingsOptions = new UniteSettingsForms();
    	
        $settingsGeneral->loadXMLFile(GlobalsUniteForms::$pathSettings."general.xml");
        $settingsOptions->loadXMLFile(GlobalsUniteForms::$pathSettings."form_options.xml");

        $this->jsonTemplateFields = $templates->getJsonTemplates(UniteFormsTemplates::TEMPLATE_TYPE_FIELDS);
        $this->jsonTemplateStyles = $templates->getJsonTemplates(UniteFormsTemplates::TEMPLATE_TYPE_STYLE);
		   
        $arrTemplatesFieldsShort = $templates->getArrTemplatesShort(UniteFormsTemplates::TEMPLATE_TYPE_FIELDS, true);
        $arrTemplatesStylesShort = $templates->getArrTemplatesShort(UniteFormsTemplates::TEMPLATE_TYPE_STYLE, true);
        
        //update settings, fill with template values:                     
        $settingTemplate = $settingsGeneral->getSettingByName("formTemplate");
        $settingTemplate["items"] = $arrTemplatesFieldsShort;
        $settingsGeneral->updateArrSettingByName("formTemplate", $settingTemplate);
                    
        $settingformStyle = $settingsGeneral->getSettingByName("formStyle");
        $settingformStyle["items"] = $arrTemplatesStylesShort; 
        $settingsGeneral->updateArrSettingByName("formStyle", $settingformStyle);
        
        //load general settings and prepare output
   	    $this->arrDefaultValues = $settingsGeneral->getArrValues();
   	     
        $arrValues = $this->form->getParams();    
                
        //options for compare
        $arrSettingsOriginal = $settingsGeneral->getArrValues();
        
        if(!empty($arrValues)){
           $settingsGeneral->setStoredValues($arrValues);
           $settingsOptions->setStoredValues($arrValues);
        }
        
        $arrGeneralSettings = $settingsGeneral->getArrValues();
		
        //$this->printSettingsDiff($arrSettingsOriginal, $arrGeneralSettings);

        //update form options
        $title = $this->form->getTitle();
        $alias = $this->form->getAlias();

        $settingsOptions->updateSettingValue("form_title", $title);
        $settingsOptions->updateSettingValue("form_alias", $alias);
		
        $arrFields = $this->form->getArrFieldsShort();
        $arrFirst = array("","Not Selected");
        $arrFields = array_merge($arrFirst,$arrFields);

        $settingsOptions->updateSettingItems("field_name", $arrFields);
        $settingsOptions->updateSettingItems("field_email", $arrFields);
        $settingsOptions->updateSettingItems("field_phone", $arrFields);
		
        //mere with options
        //$arrOptionsValues = $settingsOptions->getArrValues();
        //$arrGeneralSettings = array_merge($arrGeneralSettings, $arrOptionsValues);
        
        //prepare output
        $this->jsonGeneralSettings = UniteFunctionsForms::jsonEncodeForClientSide($arrGeneralSettings);

        $arrSettingsOptions = $settingsOptions->getArrSettings();
        
        
        $this->jsonOptionsSettings = UniteFunctionsForms::jsonEncodeForClientSide($arrSettingsOptions);
        
        $this->o = new UniteSettingsProductForms();
        $this->o->init($settingsGeneral);
        $this->o->prepareToDraw();
		
        $this->o2 = new UniteSettingsProductForms();
        $this->o2->init($settingsOptions);
        $this->o2->prepareToDraw();
        
    }
    
    
    /**
     * display function
     * 
     */
    public function display() {
    	
    	$this->isDemoMode = GlobalsUniteForms::$isDemoMode;
    	
    	
    	// Initialiase variables.
        	$formID = UniteFunctionsForms::getGetVar("id");
        	
        	//demo mode
        	if(empty($formID) && $this->isDemoMode == true){
        		try{
        			$form = new UniteFormsForm();
        			$form->initByAlias('demo');
        			$formID = $form->getID();
        			
        			dmp("please ID ($formID) to url: layout=visual&id={$formID}#/addElements");
        			exit();
        			
        		}catch(Exception $e){
        			dmp("Form with alias: 'demo' not found, please create form with alias='demo'</b>");
        			exit();
        		}
          }
        
        if (!empty($formID)) {
        	
            $this->isEmpty = false;
			$layout = UniteFunctionsForms::getGetVar("layout");
			
			$this->prepareVisualView($formID);
			
        }
        
        
        //set template
        $layout = UniteFormsAdmin::$layout;
		
		$template = "visual";
		if($layout == "preview")
			$template = "preview";
		
		require HelperBackendUF::getPathTemplate($template);
		
    }

}

$objView = new UniteFormsEditFormView();
$objView->display();



