<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;

?>
<?php $this->o2->drawHeaderIncludes(); ?>
<form name="fs.optionsForm" novalidate>
<uib-accordion close-others="'true'">
    <uib-accordion-group is-open="fs.isOpen.generalSettings">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.generalOptions, 'fa-caret-right': !fs.isOpen.generalOptions}"></i>
            General Settings
        </uib-accordion-heading>
        <fieldset>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("form_title") ?>
                    <?php $this->o2->drawSetting("form_title", "fs.formSettings.form_title") ?>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("form_alias") ?>
                    <?php $this->o2->drawSetting("form_alias", "fs.formSettings.form_alias") ?>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("form_shortcode") ?>
                    <?php $this->o2->drawSetting("form_shortcode", "fs.formSettings.form_shortcode") ?>
                </div>
            </div>
        </fieldset>
        <fieldset>
            <div class="row">
                <div class="col-sm-12 form-group uf-inline-checkbox">
                    <?php $this->o2->drawSetting("hide_on_success", "fs.formSettings.hide_on_success") ?>
                    <?php $this->o2->drawSettingTitle("hide_on_success") ?>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 form-group uf-inline-checkbox">
                    <?php $this->o2->drawSetting("redirect_after_success", "fs.formSettings.redirect_after_success") ?>
                    <?php $this->o2->drawSettingTitle("redirect_after_success") ?>
                </div>
            </div>
            <div class="row" ng-show="fs.formSettings.redirect_after_success === 'true'">
                <div class="col-sm-12 form-group uf-inline-checkbox">
                    <?php $this->o2->drawSettingTitle("redirect_link") ?>
                    <?php $this->o2->drawSetting("redirect_link", "fs.formSettings.redirect_link") ?>
                </div>
            </div>

        </fieldset>
    </uib-accordion-group>
    <uib-accordion-group is-open="fs.isOpen.admin">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.admin, 'fa-caret-right': !fs.isOpen.admin}"></i>
            Admin Emails
        </uib-accordion-heading>
        <fieldset>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("admin_email_to") ?>
                    <?php $this->o2->drawSetting("admin_email_to", "fs.formSettings.admin_email_to") ?>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("admin_email_to_cc") ?>
                    <?php $this->o2->drawSetting("admin_email_to_cc", "fs.formSettings.admin_email_to_cc") ?>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("admin_email_to_bcc") ?>
                    <?php $this->o2->drawSetting("admin_email_to_bcc", "fs.formSettings.admin_email_to_bcc") ?>
                </div>
            </div>
        </fieldset>
        
        <fieldset>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("admin_email_subject") ?>
                    <?php $this->o2->drawSetting("admin_email_subject", "fs.formSettings.admin_email_subject") ?>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("admin_email_message") ?>
                    <?php $this->o2->drawSetting("admin_email_message", "fs.formSettings.admin_email_message") ?>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("admin_email_from_address") ?>
                    <?php $this->o2->drawSetting("admin_email_from_address", "fs.formSettings.admin_email_from_address") ?>
                </div>
            </div><div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("admin_email_from_name") ?>
                    <?php $this->o2->drawSetting("admin_email_from_name", "fs.formSettings.admin_email_from_name") ?>
                </div>
            </div>
        </fieldset>
    </uib-accordion-group>
    <uib-accordion-group is-open="fs.isOpen.record">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.record, 'fa-caret-right': !fs.isOpen.record}"></i>
            Record Fields
        </uib-accordion-heading>
        <fieldset>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("field_name") ?>
                    <select id="field_name" ng-model="fs.formSettings.field_name" name="field_name" class="form-control">
                        <option selected value="">Please select</option>
                        <option ng-repeat="f in fs.activeFormElements.fields | filter:fs.onlyTextFields" ng-selected="f.id === fs.formSettings.field_name" ng-value="f.id" ng-bind="f.label"></option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("field_email") ?>
                    <select id="field_email" ng-model="fs.formSettings.field_email" name="field_email" class="form-control">
                        <option selected value="">Please select</option>
                        <option ng-repeat="f in fs.activeFormElements.fields | filter:fs.onlyTextFields" ng-selected="f.id === fs.formSettings.field_email" ng-value="f.id" ng-bind="f.label"></option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <?php $this->o2->drawSettingTitle("field_phone") ?>
                    <select id="field_phone" ng-model="fs.formSettings.field_phone" name="field_phone" class="form-control">
                        <option selected value="">Please select</option>
                        <option ng-repeat="f in fs.activeFormElements.fields | filter:fs.onlyTextFields" ng-selected="f.id === fs.formSettings.field_phone" ng-value="f.id" ng-bind="f.label"></option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-sm-12">
                    <label>
                        <br>
                        * The record fields are used in admin emails or record fields and help to understand the purpose of the field.
                    </label>
                </div>
            </div>
        </fieldset>
    </uib-accordion-group>
</uib-accordion>
</form>