<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;
?>

<uib-accordion close-others="'true'" uf-accordion-scroll-to>
    <uib-accordion-group is-open="fs.isOpen.generalStyleSettings">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.generalSettings, 'fa-caret-right': !fs.isOpen.generalSettings}"></i>
            General Settings
        </uib-accordion-heading>
        <fieldset>
            <div class="row">
                <!--            <div class="col-sm-6 form-group">-->
                <!--                --><?php //$this->o->drawSettingTitle("formTemplate") ?>
                <!--                <select class="form-control" ng-change="fs.confirmChangeFormElements()" ng-options="o.fields as o.title for o in fs.templateFields" ng-model="fs._activeFormElements">-->
                <!--                    <option value="not_selected">Not selected</option>-->
                <!--                </select>-->
                <!--            </div>-->
                <div class="col-sm-12 form-group">
                    <?php $this->o->drawSettingTitle("formStyle") ?>
                    <label class="select-customisized">
                        <select class="form-control" ng-change="fs.confirmChangeFormStyles()"
                            ng-options="o.params as o.title for o in fs.templateStyles" ng-model="fs._activeFormStyles">
                            <option value="not_selected">Not selected</option>
                        </select>
                    </label>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="col-sm-12 form-group uf-inline-checkbox">
                    <label>
                        <?php $this->o->drawSetting("formFullWidth", "fs.activeFormStyles.formFullWidth") ?>
                        Full width form
                    </label>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6 form-group">
                    <?php $this->o->drawSettingTitle("formMinWidth") ?>
                    <?php $this->o->drawSetting("formMinWidth", "fs.activeFormStyles.formMinWidth") ?>
                </div>
                <div class="col-sm-6 form-group">
                    <div ng-hide="fs.activeFormStyles.formFullWidth === 'true'">
                        <?php $this->o->drawSettingTitle("formMaxWidth") ?>
                        <?php $this->o->drawSetting("formMaxWidth", "fs.activeFormStyles.formMaxWidth") ?>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="col-sm-6 form-group">
                    <?php $this->o->drawSettingTitle("formLineHeight") ?>
                    <?php $this->o->drawSetting("formLineHeight", "fs.activeFormStyles.formLineHeight") ?>
                </div>
                <div class="col-sm-6 form-group">
                    <?php $this->o->drawSettingTitle("formDirection") ?>
                    <?php $this->o->drawSetting("formDirection", "fs.activeFormStyles.formDirection") ?>
                </div>
            </div>
        </fieldset>
    </uib-accordion-group>
    <uib-accordion-group is-open="fs.isOpen.borderBackground">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.borderBackground, 'fa-caret-right': !fs.isOpen.borderBackground}"></i>
            Border & Background
        </uib-accordion-heading>
        <fieldset>
            <div class="row">
                <div class="form-group col-lg-6 col-md-12 col-sm-12 text-nowrap">
                    <?php $this->o->drawSettingTitle("formBgType") ?>
                    <?php $this->o->drawSetting("formBgType", "fs.activeFormStyles.formBgType") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6" ng-if="fs.activeFormStyles.formBgType == 'solid' || fs.activeFormStyles.formBgType == 'img'">
                    <label>Color:</label>
                    <?php $this->o->drawSetting("formBgStartColor", "fs.activeFormStyles.formBgStartColor") ?>
                </div>
                <div ng-if="fs.activeFormStyles.formBgType == 'gradient'">
                    <div class="form-group  col-lg-3 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("formBgStartColor") ?>
                        <?php $this->o->drawSetting("formBgStartColor", "fs.activeFormStyles.formBgStartColor") ?>
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <?php $this->o->drawSettingTitle("formBgEndColor") ?>
                        <?php $this->o->drawSetting("formBgEndColor", "fs.activeFormStyles.formBgEndColor") ?>
                    </div>
                </div>
            </div>

            <div class="form-group form_img" ng-if="fs.activeFormStyles.formBgType == 'img'">
                <div class="row">
                    <div class="form-group col-sm-12">
                        <?php $this->o->drawSettingTitle("formBgImg") ?>
                        <?php $this->o->drawSetting("formBgImg", "fs.activeFormStyles.formBgImg") ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <?php $this->o->drawSettingTitle("formBgFit") ?>
                        <?php $this->o->drawSetting("formBgFit", "fs.activeFormStyles.formBgFit") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("formBgRepeat") ?>
                        <?php $this->o->drawSetting("formBgRepeat", "fs.activeFormStyles.formBgRepeat") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("formBgPosition") ?>
                        <?php $this->o->drawSetting("formBgPosition", "fs.activeFormStyles.formBgPosition") ?>
                    </div>
                </div>
            </div>

        </fieldset>
        <fieldset>
            <div class="uf-frm-row row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formBorderType") ?>
                    <?php $this->o->drawSetting("formBorderType", "fs.activeFormStyles.formBorderType") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formBorderWidth") ?>
                    <?php $this->o->drawSetting("formBorderWidth", "fs.activeFormStyles.formBorderWidth") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formBorderColor") ?>
                    <?php $this->o->drawSetting("formBorderColor", "fs.activeFormStyles.formBorderColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formBorderRadius") ?>
                    <?php $this->o->drawSetting("formBorderRadius", "fs.activeFormStyles.formBorderRadius") ?>
                </div>

            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6 text-nowrap">
                    <?php $this->o->drawSettingTitle("formShadowColor") ?>
                    <?php $this->o->drawSetting("formShadowColor", "fs.activeFormStyles.formShadowColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formShadowH") ?>
                    <?php $this->o->drawSetting("formShadowH", "fs.activeFormStyles.formShadowH") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formShadowV") ?>
                    <?php $this->o->drawSetting("formShadowV", "fs.activeFormStyles.formShadowV") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formShadowB") ?>
                    <?php $this->o->drawSetting("formShadowB", "fs.activeFormStyles.formShadowB") ?>
                </div>
                <div class="form-group col-sm-3 uf-inline-checkbox">
                    <label>
                        <?php $this->o->drawSetting("formShadowInset", "fs.activeFormStyles.formShadowInset") ?>
                        Inset
                    </label>
                </div>
            </div>
        </fieldset>

        <fieldset class="with-legend-line">
            <legend>
                Padding
            </legend>
            <label class="uf-checkbox-lock pull-right">
                <input type="checkbox" ng-model="fs.lockersState.formPadding" ng-click="fs.lockChanges('formPadding')"/>
                <i class="fa fa-lock"></i>
            </label>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formPaddingTop") ?>
                    <?php $this->o->drawSetting("formPaddingTop", "fs.activeFormStyles.formPaddingTop") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formPaddingRight") ?>
                    <?php $this->o->drawSetting("formPaddingRight", "fs.activeFormStyles.formPaddingRight") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formPaddingBottom") ?>
                    <?php $this->o->drawSetting("formPaddingBottom", "fs.activeFormStyles.formPaddingBottom") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("formPaddingLeft") ?>
                    <?php $this->o->drawSetting("formPaddingLeft", "fs.activeFormStyles.formPaddingLeft") ?>
                </div>
            </div>
        </fieldset>
    </uib-accordion-group>
    <uib-accordion-group is-open="fs.isOpen.fieldSettings">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.fieldSettings, 'fa-caret-right': !fs.isOpen.fieldSettings}"></i>
            Field Settings
        </uib-accordion-heading>
        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6 text-nowrap">
                    <?php $this->o->drawSettingTitle("fieldTextColor") ?>
                    <?php $this->o->drawSetting("fieldTextColor", "fs.activeFormStyles.fieldTextColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldFontSize") ?>
                    <?php $this->o->drawSetting("fieldFontSize", "fs.activeFormStyles.fieldFontSize") ?>
                </div>
                <div class="form-group col-lg-6 col-md-12 col-sm-12">
                    <?php $this->o->drawSettingTitle("fieldFontStyle") ?>
                    <?php $this->o->drawSetting("fieldFontStyle", "fs.activeFormStyles.fieldFontStyle") ?>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldBorderType") ?>
                    <?php $this->o->drawSetting("fieldBorderType", "fs.activeFormStyles.fieldBorderType") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldBorderSize") ?>
                    <?php $this->o->drawSetting("fieldBorderSize", "fs.activeFormStyles.fieldBorderSize") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldBorderColor") ?>
                    <?php $this->o->drawSetting("fieldBorderColor", "fs.activeFormStyles.fieldBorderColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldBorderRadius") ?>
                    <?php $this->o->drawSetting("fieldBorderRadius", "fs.activeFormStyles.fieldBorderRadius") ?>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6 text-nowrap">
                    <?php $this->o->drawSettingTitle("fieldBoxShadowColor") ?>
                    <?php $this->o->drawSetting("fieldBoxShadowColor", "fs.activeFormStyles.fieldBoxShadowColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldBoxShadowH") ?>
                    <?php $this->o->drawSetting("fieldBoxShadowH", "fs.activeFormStyles.fieldBoxShadowH") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldBoxShadowV") ?>
                    <?php $this->o->drawSetting("fieldBoxShadowV", "fs.activeFormStyles.fieldBoxShadowV") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldBoxShadowBlur") ?>
                    <?php $this->o->drawSetting("fieldBoxShadowBlur", "fs.activeFormStyles.fieldBoxShadowBlur") ?>
                </div>
                <div class="form-group  col-lg-3 col-md-6 col-sm-6 uf-inline-checkbox">
                    <label>
                        <?php $this->o->drawSetting("fieldBoxShadowInset", "fs.activeFormStyles.fieldBoxShadowInset") ?>
                        Inset
                    </label>
                </div>
            </div>
        </fieldset>
        <fieldset>
            <div class="row">
                <div class="form-group col-lg-6 col-md-12 col-sm-12 text-nowrap">
                    <?php $this->o->drawSettingTitle("fieldBgType") ?>
                    <?php $this->o->drawSetting("fieldBgType", "fs.activeFormStyles.fieldBgType") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6" ng-if="fs.activeFormStyles.fieldBgType == 'solid' || fs.activeFormStyles.fieldBgType == 'img'">
                    <label>Color:</label>
                    <?php $this->o->drawSetting("fieldBgStartColor", "fs.activeFormStyles.fieldBgStartColor") ?>
                </div>
                <div ng-if="fs.activeFormStyles.fieldBgType == 'gradient'">
                    <div class="form-group col-lg-3 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("fieldBgStartColor") ?>
                        <?php $this->o->drawSetting("fieldBgStartColor", "fs.activeFormStyles.fieldBgStartColor") ?>
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("fieldBgEndColor") ?>
                        <?php $this->o->drawSetting("fieldBgEndColor", "fs.activeFormStyles.fieldBgEndColor") ?>
                    </div>
                </div>
            </div>
            <div class="form-group form_img" ng-if="fs.activeFormStyles.fieldBgType == 'img'">
                <div class="row">
                    <div class="form-group col-sm-12">
                        <?php $this->o->drawSettingTitle("fieldBgImg") ?>
                        <?php $this->o->drawSetting("fieldBgImg", "fs.activeFormStyles.fieldBgImg") ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <?php $this->o->drawSettingTitle("fieldBgFit") ?>
                        <?php $this->o->drawSetting("fieldBgFit", "fs.activeFormStyles.fieldBgFit") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("fieldBgRepeat") ?>
                        <?php $this->o->drawSetting("fieldBgRepeat", "fs.activeFormStyles.fieldBgRepeat") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("fieldBgPosition") ?>
                        <?php $this->o->drawSetting("fieldBgPosition", "fs.activeFormStyles.fieldBgPosition") ?>
                    </div>
                </div>
            </div>
        </fieldset>
    </uib-accordion-group>
    <uib-accordion-group is-open="fs.isOpen.fieldDimension">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.fieldDimension, 'fa-caret-right': !fs.isOpen.fieldDimension}"></i>
            Field Dimension Settings
        </uib-accordion-heading>
        <fieldset>
            <div class="row">
                <div class="form-group col-lg-6 col-md-6 col-sm-6 text-nowrap">
                    <?php $this->o->drawSettingTitle("fieldWidth") ?>
                    <?php $this->o->drawSetting("fieldWidth", "fs.activeFormStyles.fieldWidth") ?>
                </div>
            </div>
        </fieldset>
        <fieldset>
            <div class="row">
                <div class="form-group col-lg-6 col-md-6 col-sm-6 text-nowrap">
                    <?php $this->o->drawSettingTitle("fieldAreaWidth") ?>
                    <?php $this->o->drawSetting("fieldAreaWidth", "fs.activeFormStyles.fieldAreaWidth") ?>
                </div>
                <div class="form-group col-lg-6 col-md-6 col-sm-6 text-nowrap">
                    <?php $this->o->drawSettingTitle("fieldAreaHeight") ?>
                    <?php $this->o->drawSetting("fieldAreaHeight", "fs.activeFormStyles.fieldAreaHeight") ?>
                </div>
            </div>
        </fieldset>

        <fieldset class="with-legend-line">
            <legend>Padding</legend>
            <label class="uf-checkbox-lock pull-right">
                <input type="checkbox" ng-model="fs.lockersState.fieldPadding" ng-click="fs.lockChanges('fieldPadding')"/>
                <i class="fa fa-lock"></i>
            </label>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldPaddingTop") ?>
                    <?php $this->o->drawSetting("fieldPaddingTop", "fs.activeFormStyles.fieldPaddingTop") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldPaddingRight") ?>
                    <?php $this->o->drawSetting("fieldPaddingRight", "fs.activeFormStyles.fieldPaddingRight") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldPaddingBottom") ?>
                    <?php $this->o->drawSetting("fieldPaddingBottom", "fs.activeFormStyles.fieldPaddingBottom") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("fieldPaddingLeft") ?>
                    <?php $this->o->drawSetting("fieldPaddingLeft", "fs.activeFormStyles.fieldPaddingLeft") ?>
                </div>
            </div>
        </fieldset>
    </uib-accordion-group>
    <uib-accordion-group is-open="fs.isOpen.label">
        <uib-accordion-heading>
            <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.label, 'fa-caret-right': !fs.isOpen.label}"></i>
            Label Settings
        </uib-accordion-heading>
        <div class="row">
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("labelAlign") ?>
                <?php $this->o->drawSetting("labelAlign", "fs.activeFormStyles.labelAlign") ?>
            </div>
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("labelFontStyle") ?>
                <?php $this->o->drawSetting("labelFontStyle", "fs.activeFormStyles.labelFontStyle") ?>
            </div>
        </div>
        <div class="row">
            <div class="form-group col-lg-4 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("labelMargin") ?>
                <?php $this->o->drawSetting("labelMargin", "fs.activeFormStyles.labelMargin") ?>
            </div>
            <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                <?php $this->o->drawSettingTitle("labelFieldColor") ?>
                <?php $this->o->drawSetting("labelFieldColor", "fs.activeFormStyles.labelFieldColor") ?>
            </div>
            <div class="form-group col-lg-4 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("labelFontSize") ?>
                <?php $this->o->drawSetting("labelFontSize", "fs.activeFormStyles.labelFontSize") ?>
            </div>
        </div>
        <div class="row">
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("labelWidth") ?>
                <?php $this->o->drawSetting("labelWidth", "fs.activeFormStyles.labelWidth") ?>
            </div>
        </div>
    </uib-accordion-group>
    <?php include_once "partials/message.php" ?>
    <?php include_once "partials/title.php" ?>
    <?php include_once "partials/description.php" ?>
    <?php include_once "partials/send-button.php" ?>
</uib-accordion>
