<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


?>

<div id="viewWrapper" class="ng-cloak uf-main-settings-area bs-wrapper uf-forms-page"
     ng-controller="formsListCtrl as fl">
    <div class="container-fluid">
        <div class="row uf-forms-header">
            <div class="col-sm-8">
                <h1>Unite Forms</h1>
            </div>
            <div class="col-sm-4 text-right uf-action-buttons">
                <!--                --><?php //if(GlobalsUniteForms::DEV_VERSION):
                //                    $viewTemplates = HelperBackendUF::getUrlView(GlobalsUniteForms::VIEW_FORM_TEMPLATES); ?>
                <!--                    <a class="btn btn-default" href="-->
                <?php //echo $viewTemplates?><!--">Edit Templates</a>-->
                <!--                --><?php //endif?>
                <a ng-click="fl.createForm()" class="btn btn-success">Add New Form</a>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">

                <table class="table table-condensed table-bordered uf-forms-table">
                    <thead>
                    <tr class="text-center">
                        <th width="40">ID</th>
                        <th>Title</th>
                        <th>Shortcode</th>
                        <th width="100" class="text-center">Edit Form</th>
                        <th width="70" class="text-center">Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr ng-repeat="f in fl.formsList | orderBy:'title'">
                        <td class="text-center" ng-bind="f.id"></td>
                        <td>
                            <a ng-href="{{fl.ufFormActionsUrls.visualView}}&id={{f.id}}#/addElements" ng-bind="f.title">
                            </a>
                        </td>
                        <td ng-bind="f.shortcode"></td>
                        <td class="text-center text-nowrap">
                            <a uib-tooltip="Add elements"
                               ng-href="{{fl.ufFormActionsUrls.visualView}}&id={{f.id}}#/addElements">
                                <i class="fa fa-plus"></i></a>&nbsp;&nbsp;
                            <a uib-tooltip="Edit settings"
                               ng-href="{{fl.ufFormActionsUrls.visualView}}&id={{f.id}}#/settings">
                                <i class="fa fa-pencil"></i></a>&nbsp;&nbsp;
                            <a uib-tooltip="Edit styles"
                               ng-href="{{fl.ufFormActionsUrls.visualView}}&id={{f.id}}#/formStyle">
                                <i class="fa fa-cog"></i></a>
                        </td>
                        <td class="text-center text-nowrap">
                            <a uib-tooltip="Delete form" href="javascript:void(0)" onfocus="this.blur()"
                               ng-click="fl.deleteForm(f)">
                                <i class="fa fa-trash"></i></a>&nbsp;&nbsp;
                            <a uib-tooltip="Copy form" href="javascript:void(0)" onfocus="this.blur()"
                               ng-click="fl.copyForm(f)">
                                <i class="fa fa-clone"></i></a>
                        </td>
                    </tr>
                    </tbody>
                    <tbody ng-if="fl.formsList.length === 0">
                    <tr>
                        <td colspan="5" class="text-center">
                            No forms found. Please create one using the 'Add a Form' button!
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="loader big" ng-show="fl.loading"></div>
        <uib-alert data-dismiss-on-timeout="5000" class="uf-alerts" ng-repeat="alert in fl.alerts" type="{{alert.type}}"
                   close="fl.closeAlert($index)">
            <div ng-bind-html="alert.msg"></div>
        </uib-alert>
    </div>
    <div class="uf-version-text" style="clear:both; margin-top: 20px;">Version: <?php echo UF_VERSION ?></div>
</div>
