<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;

?>

<uib-accordion-group is-open="fs.isOpen.sendButton" id="section-sendButton">
    <uib-accordion-heading>
        <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.sendButton, 'fa-caret-right': !fs.isOpen.sendButton}"></i>
        Send Button Settings
    </uib-accordion-heading>
    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonColor") ?>
                <?php $this->o->drawSetting("buttonColor", "fs.activeFormStyles.buttonColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonFontSize") ?>
                <?php $this->o->drawSetting("buttonFontSize", "fs.activeFormStyles.buttonFontSize") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonFontStyle") ?>
                <?php $this->o->drawSetting("buttonFontStyle", "fs.activeFormStyles.buttonFontStyle") ?>
            </div>
        </div>
    </fieldset>
    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-12 col-sm-12">
                <?php $this->o->drawSettingTitle("buttonBackgroundType") ?>
                <?php $this->o->drawSetting("buttonBackgroundType", "fs.activeFormStyles.buttonBackgroundType") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6"
                 ng-if="fs.activeFormStyles.buttonBackgroundType == 'solid' || fs.activeFormStyles.buttonBackgroundType == 'img'">
                <?php $this->o->drawSettingTitle("buttonBackgroundColor") ?>
                <?php $this->o->drawSetting("buttonBackgroundColor", "fs.activeFormStyles.buttonBackgroundColor") ?>
            </div>
            <div ng-if="fs.activeFormStyles.buttonBackgroundType == 'gradient'">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("buttonBackgroundStartColor") ?>
                    <?php $this->o->drawSetting("buttonBackgroundStartColor", "fs.activeFormStyles.buttonBackgroundStartColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("buttonBackgroundEndColor") ?>
                    <?php $this->o->drawSetting("buttonBackgroundEndColor", "fs.activeFormStyles.buttonBackgroundEndColor") ?>
                </div>
            </div>
            <div class="form-group form_img" ng-if="fs.activeFormStyles.buttonBackgroundType == 'img'">
                <div class="row">
                    <div class="form-group col-sm-12">
                        <?php $this->o->drawSettingTitle("buttonBackgroundImg") ?>
                        <?php $this->o->drawSetting("buttonBackgroundImg", "fs.activeFormStyles.buttonBackgroundImg") ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <?php $this->o->drawSettingTitle("buttonBackgroundFit") ?>
                        <?php $this->o->drawSetting("buttonBackgroundFit", "fs.activeFormStyles.buttonBackgroundFit") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("buttonBackgroundRepeat") ?>
                        <?php $this->o->drawSetting("buttonBackgroundRepeat", "fs.activeFormStyles.buttonBackgroundRepeat") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("buttonBackgroundPosition") ?>
                        <?php $this->o->drawSetting("buttonBackgroundPosition", "fs.activeFormStyles.buttonBackgroundPosition") ?>
                    </div>
                </div>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonBorderType") ?>
                <?php $this->o->drawSetting("buttonBorderType", "fs.activeFormStyles.buttonBorderType") ?>
            </div>
            <div ng-if="fs.activeFormStyles.buttonBorderType !== 'none'">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("buttonBorderSize") ?>
                    <?php $this->o->drawSetting("buttonBorderSize", "fs.activeFormStyles.buttonBorderSize") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("buttonBorderColor") ?>
                    <?php $this->o->drawSetting("buttonBorderColor", "fs.activeFormStyles.buttonBorderColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("buttonBorderRadius") ?>
                    <?php $this->o->drawSetting("buttonBorderRadius", "fs.activeFormStyles.buttonBorderRadius") ?>
                </div>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonBoxShadowColor") ?>
                <?php $this->o->drawSetting("buttonBoxShadowColor", "fs.activeFormStyles.buttonBoxShadowColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonBoxShadowH") ?>
                <?php $this->o->drawSetting("buttonBoxShadowH", "fs.activeFormStyles.buttonBoxShadowH") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonBoxShadowV") ?>
                <?php $this->o->drawSetting("buttonBoxShadowV", "fs.activeFormStyles.buttonBoxShadowV") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonBoxShadowBlur") ?>
                <?php $this->o->drawSetting("buttonBoxShadowBlur", "fs.activeFormStyles.buttonBoxShadowBlur") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6 uf-inline-checkbox">
                <label>
                    <?php $this->o->drawSetting("buttonBoxShadowInset", "fs.activeFormStyles.buttonBoxShadowInset") ?>
                    Inset
                </label>
            </div>
        </div>
    </fieldset>

    <fieldset class="with-legend-line">
        <legend>
            Padding
        </legend>
        <label class="uf-checkbox-lock pull-right">
            <input type="checkbox" ng-model="fs.lockersState.buttonPadding" ng-click="fs.lockChanges('buttonPadding')"/>
            <i class="fa fa-lock"></i>
        </label>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonPaddingTop") ?>
                <?php $this->o->drawSetting("buttonPaddingTop", "fs.activeFormStyles.buttonPaddingTop") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonPaddingRight") ?>
                <?php $this->o->drawSetting("buttonPaddingRight", "fs.activeFormStyles.buttonPaddingRight") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonPaddingBottom") ?>
                <?php $this->o->drawSetting("buttonPaddingBottom", "fs.activeFormStyles.buttonPaddingBottom") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonPaddingLeft") ?>
                <?php $this->o->drawSetting("buttonPaddingLeft", "fs.activeFormStyles.buttonPaddingLeft") ?>
            </div>
        </div>
    </fieldset>

    <fieldset class="with-legend-line">
        <legend>
            Margin
        </legend>
        <label class="uf-checkbox-lock pull-right">
            <input type="checkbox" ng-model="fs.lockersState.buttonMargin" ng-click="fs.lockChanges('buttonMargin')"/>
            <i class="fa fa-lock"></i>
        </label>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonMarginTop") ?>
                <?php $this->o->drawSetting("buttonMarginTop", "fs.activeFormStyles.buttonMarginTop") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonMarginBottom") ?>
                <?php $this->o->drawSetting("buttonMarginBottom", "fs.activeFormStyles.buttonMarginBottom") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("buttonMarginSide") ?>
                <?php $this->o->drawSetting("buttonMarginSide", "fs.activeFormStyles.buttonMarginSide") ?>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("buttonFloat") ?>
                <?php $this->o->drawSetting("buttonFloat", "fs.activeFormStyles.buttonFloat") ?>
            </div>
        </div>
    </fieldset>
</uib-accordion-group>