<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;

?>

<uib-accordion-group is-open="fs.isOpen.title" id="section-title">
    <uib-accordion-heading>
        <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.title, 'fa-caret-right': !fs.isOpen.title}"></i>
        Title Settings
    </uib-accordion-heading>
    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleColor") ?>
                <?php $this->o->drawSetting("titleColor", "fs.activeFormStyles.titleColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleFontSize") ?>
                <?php $this->o->drawSetting("titleFontSize", "fs.activeFormStyles.titleFontSize") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleFontStyle") ?>
                <?php $this->o->drawSetting("titleFontStyle", "fs.activeFormStyles.titleFontStyle") ?>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleTextShadowColor") ?>
                <?php $this->o->drawSetting("titleTextShadowColor", "fs.activeFormStyles.titleTextShadowColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleTextShadowH") ?>
                <?php $this->o->drawSetting("titleTextShadowH", "fs.activeFormStyles.titleTextShadowH") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleTextShadowV") ?>
                <?php $this->o->drawSetting("titleTextShadowV", "fs.activeFormStyles.titleTextShadowV") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleTextShadowBlur") ?>
                <?php $this->o->drawSetting("titleTextShadowBlur", "fs.activeFormStyles.titleTextShadowBlur") ?>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-12 col-sm-12">
                <?php $this->o->drawSettingTitle("titleBackgroundType") ?>
                <?php $this->o->drawSetting("titleBackgroundType", "fs.activeFormStyles.titleBackgroundType") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6"
                 ng-if="fs.activeFormStyles.titleBackgroundType == 'solid' || fs.activeFormStyles.titleBackgroundType == 'img'">
                <?php $this->o->drawSettingTitle("titleBackgroundColor") ?>
                <?php $this->o->drawSetting("titleBackgroundColor", "fs.activeFormStyles.titleBackgroundColor") ?>
            </div>
            <div ng-if="fs.activeFormStyles.titleBackgroundType == 'gradient'">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("titleBackgroundStartColor") ?>
                    <?php $this->o->drawSetting("titleBackgroundStartColor", "fs.activeFormStyles.titleBackgroundStartColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("titleBackgroundEndColor") ?>
                    <?php $this->o->drawSetting("titleBackgroundEndColor", "fs.activeFormStyles.titleBackgroundEndColor") ?>
                </div>
            </div>
            <div class="form-group form_img" ng-if="fs.activeFormStyles.titleBackgroundType == 'img'">
                <div class="row">
                    <div class="form-group col-sm-12">
                        <?php $this->o->drawSettingTitle("titleBackgroundImg") ?>
                        <?php $this->o->drawSetting("titleBackgroundImg", "fs.activeFormStyles.titleBackgroundImg") ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <?php $this->o->drawSettingTitle("titleBackgroundFit") ?>
                        <?php $this->o->drawSetting("titleBackgroundFit", "fs.activeFormStyles.titleBackgroundFit") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("titleBackgroundRepeat") ?>
                        <?php $this->o->drawSetting("titleBackgroundRepeat", "fs.activeFormStyles.titleBackgroundRepeat") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("titleBackgroundPosition") ?>
                        <?php $this->o->drawSetting("titleBackgroundPosition", "fs.activeFormStyles.titleBackgroundPosition") ?>
                    </div>
                </div>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleBorderType") ?>
                <?php $this->o->drawSetting("titleBorderType", "fs.activeFormStyles.titleBorderType") ?>
            </div>
            <div ng-if="fs.activeFormStyles.titleBorderType !== 'none'">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("titleBorderSize") ?>
                    <?php $this->o->drawSetting("titleBorderSize", "fs.activeFormStyles.titleBorderSize") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("titleBorderColor") ?>
                    <?php $this->o->drawSetting("titleBorderColor", "fs.activeFormStyles.titleBorderColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("titleBorderRadius") ?>
                    <?php $this->o->drawSetting("titleBorderRadius", "fs.activeFormStyles.titleBorderRadius") ?>
                </div>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleBoxShadowColor") ?>
                <?php $this->o->drawSetting("titleBoxShadowColor", "fs.activeFormStyles.titleBoxShadowColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleBoxShadowH") ?>
                <?php $this->o->drawSetting("titleBoxShadowH", "fs.activeFormStyles.titleBoxShadowH") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleBoxShadowV") ?>
                <?php $this->o->drawSetting("titleBoxShadowV", "fs.activeFormStyles.titleBoxShadowV") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleBoxShadowBlur") ?>
                <?php $this->o->drawSetting("titleBoxShadowBlur", "fs.activeFormStyles.titleBoxShadowBlur") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6 uf-inline-checkbox">
                <label>
                    <?php $this->o->drawSetting("titleBoxShadowInset", "fs.activeFormStyles.titleBoxShadowInset") ?>
                    Inset
                </label>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("titleWidth") ?>
                <?php $this->o->drawSetting("titleWidth", "fs.activeFormStyles.titleWidth") ?>
            </div>
        </div>

    </fieldset>

    <fieldset class="with-legend-line">
        <legend>
            Padding
        </legend>
        <label class="uf-checkbox-lock pull-right">
            <input type="checkbox" ng-model="fs.lockersState.titlePadding" ng-click="fs.lockChanges('titlePadding')"/>
            <i class="fa fa-lock"></i>
        </label>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titlePaddingTop") ?>
                <?php $this->o->drawSetting("titlePaddingTop", "fs.activeFormStyles.titlePaddingTop") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titlePaddingRight") ?>
                <?php $this->o->drawSetting("titlePaddingRight", "fs.activeFormStyles.titlePaddingRight") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titlePaddingBottom") ?>
                <?php $this->o->drawSetting("titlePaddingBottom", "fs.activeFormStyles.titlePaddingBottom") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titlePaddingLeft") ?>
                <?php $this->o->drawSetting("titlePaddingLeft", "fs.activeFormStyles.titlePaddingLeft") ?>
            </div>
        </div>
    </fieldset>

    <fieldset class="with-legend-line">
        <legend>
            Margin
        </legend>
        <label class="uf-checkbox-lock pull-right">
            <input type="checkbox" ng-model="fs.lockersState.titleMargin" ng-click="fs.lockChanges('titleMargin')"/>
            <i class="fa fa-lock"></i>
        </label>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleMarginTop") ?>
                <?php $this->o->drawSetting("titleMarginTop", "fs.activeFormStyles.titleMarginTop") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleMarginRight") ?>
                <?php $this->o->drawSetting("titleMarginRight", "fs.activeFormStyles.titleMarginRight") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleMarginBottom") ?>
                <?php $this->o->drawSetting("titleMarginBottom", "fs.activeFormStyles.titleMarginBottom") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("titleMarginLeft") ?>
                <?php $this->o->drawSetting("titleMarginLeft", "fs.activeFormStyles.titleMarginLeft") ?>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("titleAlign") ?>
                <?php $this->o->drawSetting("titleAlign", "fs.activeFormStyles.titleAlign") ?>
            </div>
        </div>
    </fieldset>
</uib-accordion-group>