<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/gravopr/public_html/flexicon-bg.com/templates/rt_callisto/particles/contenttabs.yaml',
    'modified' => 1536742799,
    'data' => [
        'name' => 'Content Tabs',
        'description' => 'Displays Content Tabs.',
        'type' => 'particle',
        'icon' => 'fa-table',
        'configuration' => [
            'caching' => [
                'type' => 'static'
            ]
        ],
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable particle.',
                    'default' => true
                ],
                'class' => [
                    'type' => 'input.selectize',
                    'label' => 'CSS Classes',
                    'description' => 'CSS class name for the particle.'
                ],
                'title' => [
                    'type' => 'input.text',
                    'label' => 'Title',
                    'description' => 'Customize the particle title text.',
                    'placeholder' => 'Enter title'
                ],
                'animation' => [
                    'type' => 'select.select',
                    'label' => 'Animation Type',
                    'description' => 'Set the animation type.',
                    'default' => 'right',
                    'options' => [
                        'left' => 'Slide Left',
                        'right' => 'Slide Right',
                        'up' => 'Slide Up',
                        'down' => 'Slide Down',
                        'fade' => 'Fade',
                        'toggle' => 'Toggle'
                    ]
                ],
                'items' => [
                    'type' => 'collection.list',
                    'array' => true,
                    'label' => 'Content Tabs Items',
                    'description' => 'Content Tabs item to display.',
                    'value' => 'title',
                    'ajax' => true,
                    'fields' => [
                        '.title' => [
                            'type' => 'input.text',
                            'label' => 'Title',
                            'description' => 'Enter the title'
                        ],
                        '.linklabel' => [
                            'type' => 'input.text',
                            'label' => 'Read More Text',
                            'description' => 'Specify the read more text.',
                            'placeholder' => 'Read More'
                        ],
                        '.link' => [
                            'type' => 'input.text',
                            'label' => 'Read More Link',
                            'description' => 'Specify the Read More link address.'
                        ],
                        '.content' => [
                            'type' => 'textarea.textarea',
                            'label' => 'Tab Content',
                            'description' => 'Customize the tab content.',
                            'placeholder' => 'Enter your custom content here.'
                        ]
                    ]
                ]
            ]
        ]
    ]
];
