<?php
/**
 * @package     Joomla.Module
 * @subpackage  mod_ivm_gmap_location
 * @link        http://www.kreativan.net
 * @copyright   Ivan Milincic - www.kreativan.net. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

?>
<style>
    .ivm-gmap-<?=$module_id?> .ivm-gmap-navigation {
        background:<?=$navBG?>;
        border:1px solid <?=$navBorder?>;
    }
    .ivm-gmap-<?=$module_id?> .ivm-map-nav-item {
        border-bottom:1px solid <?=$navBorder?>;
        color:<?=$navColor?>;
    }
    .ivm-gmap-<?=$module_id?> .ivm-map-nav-item.ivm-active,
    .ivm-gmap-<?=$module_id?> .ivm-map-nav-item:hover {
        background: <?=$navHoverBG?>;
        color:<?=$navHoverColor?>;
    }

    <?php if( ($params->get('navigation') == 1) && ($params->get('responsive') == 1) ) :?>
        @media (max-width: <?=$params->get('break_point')?>) {
            .ivm-gmap-location .ivm-gmap-navigation {
                /*position:relative !important;*/
                /*display:none !important;*/
                display:none !important;
                width:70% !important;
                float:none !important;
                position:fixed !important;
                top:0 !important;
                bottom:0 !important;
                left:0 !important;
                right:auto !important;
                height:100% !important;
                z-index:1002;
                overflow:scroll !important;
            }
            .ivm-gmap-location .ivm-gmap-container {
                padding:0px !important;
                float:none !important;
            }
            .ivm-gmap-location .slimScrollDiv > div:first-child,
            .ivm-gmap-location .slimScrollDiv {
                height:100% !important
            }
            .ivm-gmap-location .ivm-gmap-navigation.ivm-nav-visible {
                display:block !important;
                box-shadow:5px 0 20px rgba(0, 0, 0, 0.5);
            }

            .ivm-nav-visible .ivm-gmap-nav-button-close {
                display: block;
                position: fixed;
                top:0;
                bottom:0;
                left:100%;
                right:0;
                width:100%;
                z-index:0;
                background: transparent;
            }
            .ivm-gmap-nav-button {
                display:block;
            }
        <?php endif;?>

    }
</style>
<?php if($params->get('navigation') == 1) :?>
    <script>
        jQuery(function($) {

            if($(window).width() >= 768) {
                $('.ivm-gmap-<?=$module_id?> .ivm-gmap-navigation > div').slimScroll({
                    //width: '350px',
                    height: '<?=$map_height?>',
                    size: '7px',
                    <?php if($navPoz == 'left') :?>
                        position: 'right',
                    <?php else: ?>
                        position: 'left',
                    <?php endif;?>
                    color: '<?=$navScrollColor?>',
                    alwaysVisible: false,
                    distance: '0px',
                    railVisible: false,
                    railColor: '#222',
                    railOpacity: 0.2,
                    wheelStep: 10,
                    allowPageScroll: false,
                    disableFadeOut: true
                });
            }

            // toggle active class
            $( ".ivm-gmap-<?=$module_id?> .ivm-map-nav-item:first-child" ).addClass( "ivm-active" );
            $( ".ivm-gmap-<?=$module_id?> .ivm-map-nav-item" ).click(function() {
                $( ".ivm-gmap-<?=$module_id?> .ivm-map-nav-item" ).removeClass( "ivm-active" );
                $( this ).addClass( "ivm-active" );
            });

            <?php if( ($params->get('navigation') == 1) && ($params->get('responsive') == 1) ) :?>
                $( ".ivm-gmap-<?=$module_id?> .ivm-gmap-nav-button" ).click(function() {
                    $( ".ivm-gmap-<?=$module_id?> .ivm-gmap-navigation" ).addClass( "ivm-nav-visible" );
                });
                $( ".ivm-gmap-<?=$module_id?> .ivm-map-nav-item" ).click(function() {
                    $( ".ivm-gmap-<?=$module_id?> .ivm-gmap-navigation" ).removeClass( "ivm-nav-visible" );
                });
                $( ".ivm-gmap-<?=$module_id?> .ivm-gmap-nav-button-close" ).click(function() {
                    $( ".ivm-gmap-<?=$module_id?> .ivm-gmap-navigation" ).removeClass( "ivm-nav-visible" );
                });
            <?php endif;?>

        });
    </script>
<?php endif?>
