<?php
/**
 * @package   plg_addcookielaw
 * @author    Addaptive <info@addaptive.com>
 * @copyright Copyright (C)2015 Addaptive. All rights reserved.
 * @license   GNU General Public License, version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('hidden');

/**
 * Class JFormFieldThumbprint
 *
 * A minimalistic editor to avoid using Joomla craps for little text portions.
 */
class JFormFieldThumbprint extends JFormFieldHidden
{
	/**
	 * @var string
	 */
	protected $type = 'Thumbprint';

	/**
	 * Method to instantiate the form field object.
	 *
	 * @param   JForm $form The form to attach to the form field object.
	 *
	 * @since   11.1
	 */
	public function __construct($form = null)
	{
		parent::__construct($form);

		// Add the behavior for the button
		JHtml::script('plugins/system/addcookielaw/forms/fields/thumbprint/main.js');
	}


	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   11.1
	 */
	protected function getInput()
	{
		if (empty($this->value))
		{
			$this->value = time();
		}

		// Pass needed translations to Javascript
		JText::script('PLG_ADDCOOKIELAW_THUMBPRINT_BUTTON_CONFIRM');

		return parent::getInput() . '<a href="#" class="btn btn-info prompt_consent">'
		. JText::_('PLG_ADDCOOKIELAW_THUMBPRINT_BUTTON') . ' </a> ';
	}
}