<?php
/**
 * @package   plg_addcookielaw
 * @author    Addaptive <info@addaptive.com>
 * @copyright Copyright (C)2015 Addaptive. All rights reserved.
 * @license   GNU General Public License, version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * @see   http://dev.airve.com/demo/speed_tests/php/parse_attrs.php
 *
 * Parse a string of attributes into an array. If the string starts with a tag and, then the attributes on the first tag
 * are parsed. This version is safer and does not depend on the DOMDocument interface.
 *
 * @param string|* $attributes
 *
 * @return array
 */
function parse_attrs($attributes)
{
	if (!is_scalar($attributes))
	{
		return (array) $attributes;
	}

	$attributes = trim($attributes);
	$attributes = str_split($attributes);

	if ('<' === $attributes[0]) // looks like a tag so strip the tag name
	{
		$attributes = implode('', $attributes);
		$attributes = ltrim($attributes, '<');
		$attributes = str_split($attributes);

		while ($attributes && !ctype_space($attributes[0]))
		{
			array_shift($attributes);
		}
	}

	$arr   = array(); // output
	$name  = '';      // for the current attr being parsed
	$value = '';      // for the current attr being parsed
	$mode  = 0;       // whether current char is part of the name (-), the value (+), or neither (0)
	$stop  = false;   // delimiter for the current $value being parsed
	$space = ' ';     // a single space

	foreach ($attributes as $j => $curr)
	{
		if ($mode < 0) // name
		{
			if ('=' === $curr)
			{
				$mode = 1;
				$stop = false;
			}
			elseif ('>' === $curr)
			{
				'' === $name or $arr[$name] = $value;
				break;
			}
			elseif (!ctype_space($curr))
			{
				if (ctype_space($attributes[$j - 1])) // previous char
				{
					'' === $name or $arr[$name] = '';   // previous name
					$name = $curr;                      // initiate new
				}
				else
				{
					$name .= $curr;
				}
			}
		}
		elseif ($mode > 0) // value
		{
			if ($stop === false)
			{
				if (!ctype_space($curr))
				{
					if ('"' === $curr || "'" === $curr)
					{
						$value = '';
						$stop  = $curr;
					}
					else
					{
						$value = $curr;
						$stop  = $space;
					}
				}
			}
			elseif ($stop === $space ? ctype_space($curr) : $curr === $stop)
			{
				$arr[$name] = $value;
				$mode       = 0;
				$name       = $value = '';
			}
			else
			{
				$value .= $curr;
			}
		}
		else // neither
		{

			if ('>' === $curr)
				break;
			if (!ctype_space($curr))
			{
				# initiate
				$name = $curr;
				$mode = -1;
			}
		}
	}

	// incl the final pair (if it was quoteless)
	'' === $name or $arr[$name] = $value;

	return $arr;
}